<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class StockPlansSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $stockPlans = [
            [
                'name' => 'Apple Premium Stock',
                'plan_type' => 'stock',
                'stock_symbol' => 'NASDAQ:AAPL',
                'stock_company' => 'Apple Inc.',
                'stock_description' => 'Invest in the world\'s most valuable technology company with consistent returns.',
                'price' => 500,
                'min_price' => 500,
                'max_price' => 50000,
                'minr' => 8,
                'maxr' => 15,
                'gift' => 50,
                'expected_return' => 12,
                'increment_type' => 'Percentage',
                'increment_interval' => 'Daily',
                'increment_amount' => 0.4,
                'expiration' => '3 Months',
            ],
            [
                'name' => 'Microsoft Enterprise Stock',
                'plan_type' => 'stock',
                'stock_symbol' => 'NASDAQ:MSFT',
                'stock_company' => 'Microsoft Corporation',
                'stock_description' => 'Invest in cloud computing and enterprise software leader with steady growth.',
                'price' => 1000,
                'min_price' => 1000,
                'max_price' => 100000,
                'minr' => 10,
                'maxr' => 18,
                'gift' => 100,
                'expected_return' => 15,
                'increment_type' => 'Percentage',
                'increment_interval' => 'Daily',
                'increment_amount' => 0.5,
                'expiration' => '6 Months',
            ],
            [
                'name' => 'Tesla Growth Stock',
                'plan_type' => 'stock',
                'stock_symbol' => 'NASDAQ:TSLA',
                'stock_company' => 'Tesla Inc.',
                'stock_description' => 'High-growth electric vehicle manufacturer with revolutionary technology.',
                'price' => 250,
                'min_price' => 250,
                'max_price' => 25000,
                'minr' => 12,
                'maxr' => 25,
                'gift' => 25,
                'expected_return' => 20,
                'increment_type' => 'Percentage',
                'increment_interval' => 'Daily',
                'increment_amount' => 0.67,
                'expiration' => '3 Months',
            ],
            [
                'name' => 'Google Tech Stock',
                'plan_type' => 'stock',
                'stock_symbol' => 'NASDAQ:GOOGL',
                'stock_company' => 'Alphabet Inc.',
                'stock_description' => 'Leading search engine and AI innovation company with strong fundamentals.',
                'price' => 800,
                'min_price' => 800,
                'max_price' => 80000,
                'minr' => 9,
                'maxr' => 16,
                'gift' => 80,
                'expected_return' => 13,
                'increment_type' => 'Percentage',
                'increment_interval' => 'Daily',
                'increment_amount' => 0.43,
                'expiration' => '6 Months',
            ],
            [
                'name' => 'Amazon E-commerce Stock',
                'plan_type' => 'stock',
                'stock_symbol' => 'NASDAQ:AMZN',
                'stock_company' => 'Amazon.com Inc.',
                'stock_description' => 'Global e-commerce and cloud computing giant with diverse revenue streams.',
                'price' => 1200,
                'min_price' => 1200,
                'max_price' => 150000,
                'minr' => 11,
                'maxr' => 20,
                'gift' => 150,
                'expected_return' => 16,
                'increment_type' => 'Percentage',
                'increment_interval' => 'Daily',
                'increment_amount' => 0.53,
                'expiration' => '12 Months',
            ],
            [
                'name' => 'Meta Social Stock',
                'plan_type' => 'stock',
                'stock_symbol' => 'NASDAQ:META',
                'stock_company' => 'Meta Platforms Inc.',
                'stock_description' => 'Leading social media and metaverse technology company.',
                'price' => 400,
                'min_price' => 400,
                'max_price' => 40000,
                'minr' => 10,
                'maxr' => 18,
                'gift' => 40,
                'expected_return' => 14,
                'increment_type' => 'Percentage',
                'increment_interval' => 'Daily',
                'increment_amount' => 0.47,
                'expiration' => '3 Months',
            ],
            [
                'name' => 'Netflix Streaming Stock',
                'plan_type' => 'stock',
                'stock_symbol' => 'NASDAQ:NFLX',
                'stock_company' => 'Netflix Inc.',
                'stock_description' => 'Premier streaming entertainment service with global subscriber base.',
                'price' => 300,
                'min_price' => 300,
                'max_price' => 30000,
                'minr' => 8,
                'maxr' => 15,
                'gift' => 30,
                'expected_return' => 12,
                'increment_type' => 'Percentage',
                'increment_interval' => 'Daily',
                'increment_amount' => 0.4,
                'expiration' => '6 Months',
            ],
            [
                'name' => 'NVIDIA AI Stock',
                'plan_type' => 'stock',
                'stock_symbol' => 'NASDAQ:NVDA',
                'stock_company' => 'NVIDIA Corporation',
                'stock_description' => 'Leading GPU manufacturer powering AI and gaming revolution.',
                'price' => 1500,
                'min_price' => 1500,
                'max_price' => 200000,
                'minr' => 15,
                'maxr' => 30,
                'gift' => 200,
                'expected_return' => 22,
                'increment_type' => 'Percentage',
                'increment_interval' => 'Daily',
                'increment_amount' => 0.73,
                'expiration' => '6 Months',
            ],
            [
                'name' => 'AMD Processor Stock',
                'plan_type' => 'stock',
                'stock_symbol' => 'NASDAQ:AMD',
                'stock_company' => 'Advanced Micro Devices Inc.',
                'stock_description' => 'High-performance computing and graphics technology leader.',
                'price' => 350,
                'min_price' => 350,
                'max_price' => 35000,
                'minr' => 12,
                'maxr' => 22,
                'gift' => 35,
                'expected_return' => 17,
                'increment_type' => 'Percentage',
                'increment_interval' => 'Daily',
                'increment_amount' => 0.57,
                'expiration' => '3 Months',
            ],
            [
                'name' => 'Intel Chip Stock',
                'plan_type' => 'stock',
                'stock_symbol' => 'NASDAQ:INTC',
                'stock_company' => 'Intel Corporation',
                'stock_description' => 'Established semiconductor manufacturer with strong market presence.',
                'price' => 200,
                'min_price' => 200,
                'max_price' => 20000,
                'minr' => 6,
                'maxr' => 12,
                'gift' => 20,
                'expected_return' => 9,
                'increment_type' => 'Percentage',
                'increment_interval' => 'Daily',
                'increment_amount' => 0.3,
                'expiration' => '6 Months',
            ],
            [
                'name' => 'Disney Entertainment Stock',
                'plan_type' => 'stock',
                'stock_symbol' => 'NYSE:DIS',
                'stock_company' => 'The Walt Disney Company',
                'stock_description' => 'Global entertainment and media conglomerate with iconic brands.',
                'price' => 450,
                'min_price' => 450,
                'max_price' => 45000,
                'minr' => 7,
                'maxr' => 14,
                'gift' => 45,
                'expected_return' => 11,
                'increment_type' => 'Percentage',
                'increment_interval' => 'Daily',
                'increment_amount' => 0.37,
                'expiration' => '6 Months',
            ],
            [
                'name' => 'Coca-Cola Beverage Stock',
                'plan_type' => 'stock',
                'stock_symbol' => 'NYSE:KO',
                'stock_company' => 'The Coca-Cola Company',
                'stock_description' => 'World\'s largest beverage company with stable dividend history.',
                'price' => 150,
                'min_price' => 150,
                'max_price' => 15000,
                'minr' => 5,
                'maxr' => 10,
                'gift' => 15,
                'expected_return' => 7.5,
                'increment_type' => 'Percentage',
                'increment_interval' => 'Daily',
                'increment_amount' => 0.25,
                'expiration' => '12 Months',
            ],
            [
                'name' => 'Nike Sportswear Stock',
                'plan_type' => 'stock',
                'stock_symbol' => 'NYSE:NKE',
                'stock_company' => 'Nike Inc.',
                'stock_description' => 'Leading athletic footwear and apparel brand with global reach.',
                'price' => 300,
                'min_price' => 300,
                'max_price' => 30000,
                'minr' => 8,
                'maxr' => 15,
                'gift' => 30,
                'expected_return' => 11.5,
                'increment_type' => 'Percentage',
                'increment_interval' => 'Daily',
                'increment_amount' => 0.38,
                'expiration' => '6 Months',
            ],
            [
                'name' => 'McDonald\'s Food Stock',
                'plan_type' => 'stock',
                'stock_symbol' => 'NYSE:MCD',
                'stock_company' => 'McDonald\'s Corporation',
                'stock_description' => 'Global fast-food leader with consistent performance and dividends.',
                'price' => 250,
                'min_price' => 250,
                'max_price' => 25000,
                'minr' => 6,
                'maxr' => 12,
                'gift' => 25,
                'expected_return' => 9,
                'increment_type' => 'Percentage',
                'increment_interval' => 'Daily',
                'increment_amount' => 0.3,
                'expiration' => '9 Months',
            ],
            [
                'name' => 'Visa Payment Stock',
                'plan_type' => 'stock',
                'stock_symbol' => 'NYSE:V',
                'stock_company' => 'Visa Inc.',
                'stock_description' => 'Global payment technology company with strong transaction growth.',
                'price' => 600,
                'min_price' => 600,
                'max_price' => 60000,
                'minr' => 9,
                'maxr' => 17,
                'gift' => 60,
                'expected_return' => 13,
                'increment_type' => 'Percentage',
                'increment_interval' => 'Daily',
                'increment_amount' => 0.43,
                'expiration' => '6 Months',
            ],
            [
                'name' => 'Mastercard Finance Stock',
                'plan_type' => 'stock',
                'stock_symbol' => 'NYSE:MA',
                'stock_company' => 'Mastercard Inc.',
                'stock_description' => 'Leading payment processing network with expanding digital services.',
                'price' => 550,
                'min_price' => 550,
                'max_price' => 55000,
                'minr' => 9,
                'maxr' => 16,
                'gift' => 55,
                'expected_return' => 12.5,
                'increment_type' => 'Percentage',
                'increment_interval' => 'Daily',
                'increment_amount' => 0.42,
                'expiration' => '6 Months',
            ],
            [
                'name' => 'JPMorgan Banking Stock',
                'plan_type' => 'stock',
                'stock_symbol' => 'NYSE:JPM',
                'stock_company' => 'JPMorgan Chase & Co.',
                'stock_description' => 'Largest U.S. bank with diversified financial services and strong balance sheet.',
                'price' => 700,
                'min_price' => 700,
                'max_price' => 70000,
                'minr' => 8,
                'maxr' => 15,
                'gift' => 70,
                'expected_return' => 11,
                'increment_type' => 'Percentage',
                'increment_interval' => 'Daily',
                'increment_amount' => 0.37,
                'expiration' => '12 Months',
            ],
            [
                'name' => 'Boeing Aerospace Stock',
                'plan_type' => 'stock',
                'stock_symbol' => 'NYSE:BA',
                'stock_company' => 'The Boeing Company',
                'stock_description' => 'Leading aerospace manufacturer with commercial and defense contracts.',
                'price' => 400,
                'min_price' => 400,
                'max_price' => 40000,
                'minr' => 10,
                'maxr' => 20,
                'gift' => 40,
                'expected_return' => 15,
                'increment_type' => 'Percentage',
                'increment_interval' => 'Daily',
                'increment_amount' => 0.5,
                'expiration' => '6 Months',
            ],
            [
                'name' => 'Walmart Retail Stock',
                'plan_type' => 'stock',
                'stock_symbol' => 'NYSE:WMT',
                'stock_company' => 'Walmart Inc.',
                'stock_description' => 'World\'s largest retailer with strong e-commerce growth and stable returns.',
                'price' => 350,
                'min_price' => 350,
                'max_price' => 35000,
                'minr' => 6,
                'maxr' => 13,
                'gift' => 35,
                'expected_return' => 9.5,
                'increment_type' => 'Percentage',
                'increment_interval' => 'Daily',
                'increment_amount' => 0.32,
                'expiration' => '9 Months',
            ],
            [
                'name' => 'Berkshire Investment Stock',
                'plan_type' => 'stock',
                'stock_symbol' => 'NYSE:BRK.B',
                'stock_company' => 'Berkshire Hathaway Inc.',
                'stock_description' => 'Warren Buffett\'s holding company with diversified investments and strong fundamentals.',
                'price' => 1000,
                'min_price' => 1000,
                'max_price' => 100000,
                'minr' => 10,
                'maxr' => 18,
                'gift' => 100,
                'expected_return' => 14,
                'increment_type' => 'Percentage',
                'increment_interval' => 'Daily',
                'increment_amount' => 0.47,
                'expiration' => '12 Months',
            ],
        ];

        $now = Carbon::now();

        foreach ($stockPlans as $plan) {
            DB::table('plans')->insert([
                'name' => $plan['name'],
                'plan_type' => $plan['plan_type'],
                'stock_symbol' => $plan['stock_symbol'],
                'stock_company' => $plan['stock_company'],
                'stock_description' => $plan['stock_description'],
                'price' => $plan['price'],
                'min_price' => $plan['min_price'],
                'max_price' => $plan['max_price'],
                'minr' => $plan['minr'],
                'maxr' => $plan['maxr'],
                'gift' => $plan['gift'],
                'expected_return' => $plan['expected_return'],
                'increment_type' => $plan['increment_type'],
                'increment_interval' => $plan['increment_interval'],
                'increment_amount' => $plan['increment_amount'],
                'expiration' => $plan['expiration'],
                'type' => 'Main',
                'created_at' => $now,
                'updated_at' => $now,
            ]);
        }

        $this->command->info('Successfully created 20 stock plans!');
    }
}
