'use strict';
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
import HttpClient from './clients/httpClient';
import ConfigurationClient from './clients/copyfactory/configuration.client';
import HistoryClient from './clients/copyfactory/history.client';
import TradingClient from './clients/copyfactory/trading.client';
import DomainClient from './clients/domain.client';
import LoggerManager from './logger';
let CopyFactory = class CopyFactory {
    /**
   * Enables using Log4js logger with extended log levels for debugging instead of
   * console.* functions. Note that log4js configuration performed by the user.
   */ static enableLog4jsLogging() {
        LoggerManager.useLog4js();
    }
    /**
   * Returns CopyFactory configuration API
   * @returns {ConfigurationClient} configuration API
   */ get configurationApi() {
        return this._configurationClient;
    }
    /**
   * Returns CopyFactory history API
   * @return {HistoryClient} history API
   */ get historyApi() {
        return this._historyClient;
    }
    /**
   * Returns CopyFactory trading API
   * @return {TradingClient} trading API
   */ get tradingApi() {
        return this._tradingClient;
    }
    /**
   * Constructs CopyFactory class instance
   * @param {String} token authorization token
   * @param {Object} opts connection options
   * @param {String} [opts.domain] domain to connect to
   * @param {String} [opts.extendedTimeout] timeout for extended http requests in seconds
   * @param {Number} [opts.requestTimeout] timeout for http requests in seconds
   */ constructor(token, opts = {}){
        _define_property(this, "_domain", void 0);
        _define_property(this, "_httpClient", void 0);
        _define_property(this, "_domainClient", void 0);
        _define_property(this, "_configurationClient", void 0);
        _define_property(this, "_historyClient", void 0);
        _define_property(this, "_tradingClient", void 0);
        this._domain = opts.domain || 'agiliumtrade.agiliumtrade.ai';
        let requestTimeout = opts.requestTimeout || 10;
        let requestExtendedTimeout = opts.extendedTimeout || 70;
        const retryOpts = opts.retryOpts || {};
        this._httpClient = new HttpClient(requestTimeout, requestExtendedTimeout, retryOpts);
        this._domainClient = new DomainClient(this._httpClient, token, this._domain);
        this._configurationClient = new ConfigurationClient(this._domainClient);
        this._historyClient = new HistoryClient(this._domainClient);
        this._tradingClient = new TradingClient(this._domainClient, this._configurationClient);
    }
};
/**
 * MetaApi CopyFactory copy trading API SDK
 */ export { CopyFactory as default };

//# sourceMappingURL=data:application/json;base64,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