"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return MetatraderAccountGeneratorClient;
    }
});
const _metaApiclient = /*#__PURE__*/ _interop_require_default(require("../metaApi.client"));
const _randomstring = /*#__PURE__*/ _interop_require_default(require("randomstring"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let MetatraderAccountGeneratorClient = class MetatraderAccountGeneratorClient extends _metaApiclient.default {
    /**
   * New MetaTrader 4 demo account request model
   * @typedef {Object} NewMT4DemoAccount
   * @property {string} accountType account type. Available account type values can be found in mobile MT application or
   * in MT terminal downloaded from our broker
   * @property {number} balance account balance
   * @property {string} email account holder's email
   * @property {number} leverage account leverage
   * @property {string} name account holder's name
   * @property {string} phone account holder's phone, in international format
   * @property {string} serverName server name
   * @property {Array<String>} [keywords] keywords to be used for broker server search.
   * We recommend to include exact broker company name in this list 
   */ /**
   * New MetaTrader 5 demo account request model
   * @typedef {Object} NewMT5DemoAccount
   * @property {string} accountType account type. Available account type values can be found in mobile MT application or
   * in MT terminal downloaded from our broker
   * @property {number} balance account balance
   * @property {string} email account holder's email
   * @property {number} leverage account leverage
   * @property {string} name account holder's name
   * @property {string} phone account holder's phone, in international format
   * @property {string} serverName server name
   * @property {Array<String>} [keywords] keywords to be used for broker server search.
   * We recommend to include exact broker company name in this list
   */ /**
   * MetaTrader account credetials model
   * @typedef {Object} MetatraderAccountCredentialsDto
   * @property {String} login account login
   * @property {String} password account password
   * @property {String} serverName MetaTrader server name
   * @property {String} investorPassword account investor (read-only) password
   */ /**
   * Creates new MetaTrader 4 demo account
   * See https://metaapi.cloud/docs/provisioning/api/generateAccount/createMT4DemoAccount/
   * Method is accessible only with API access token
   * @param {NewMT4DemoAccount} account account to create
   * @param {string} [profileId] id of the provisioning profile that will be used as the basis for creating this account
   * @return {Promise<MetatraderAccountCredentialsDto>} promise resolving with MetaTrader account credetials
   */ createMT4DemoAccount(account, profileId) {
        if (this._isNotJwtToken()) {
            return this._handleNoAccessError("createMT4DemoAccount");
        }
        const opts = {
            url: `${this._host}/users/current/provisioning-profiles/${profileId || "default"}/mt4-demo-accounts`,
            method: "POST",
            headers: {
                "auth-token": this._token,
                "transaction-id": _randomstring.default.generate(32)
            },
            json: true,
            data: account
        };
        return this._httpClient.request(opts, "createMT4DemoAccount");
    }
    /**
   * Creates new MetaTrader 5 demo account.
   * See https://metaapi.cloud/docs/provisioning/api/generateAccount/createMT5DemoAccount/
   * Method is accessible only with API access token
   * @param {NewMT5DemoAccount} account account to create
   * @param {string} [profileId] id of the provisioning profile that will be used as the basis for creating this account
   * @return {Promise<MetatraderAccountCredentialsDto>} promise resolving with MetaTrader account credentials
   */ createMT5DemoAccount(account, profileId) {
        if (this._isNotJwtToken()) {
            return this._handleNoAccessError("createMT5DemoAccount");
        }
        const opts = {
            url: `${this._host}/users/current/provisioning-profiles/${profileId || "default"}/mt5-demo-accounts`,
            method: "POST",
            headers: {
                "auth-token": this._token,
                "transaction-id": _randomstring.default.generate(32)
            },
            json: true,
            data: account
        };
        return this._httpClient.request(opts, "createMT5DemoAccount");
    }
};

//# sourceMappingURL=data:application/json;base64,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