"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return _default;
    }
});
const _log4jsapi = /*#__PURE__*/ _interop_require_default(require("@log4js-node/log4js-api"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let log4jsEnabled = false;
/**
 * Manages loggers of the entire sdk
 */ let LoggerManager = class LoggerManager {
    /**
   * Enables using Log4js logger with extended log levels for debugging instead of
   * console.* functions. Note that log4js configuration performed by the user.
   */ static useLog4js() {
        log4jsEnabled = true;
    }
    /**
   * Creates a new logger for specified category
   * @param {String} category Logger category
   * @return {Logger} Created logger
   */ static getLogger(category) {
        if (log4jsEnabled) {
            const logger = _log4jsapi.default.getLogger(category);
            if (logger._log) {
                const originalLog = logger._log.bind(logger);
                logger._log = function(level, data) {
                    if (typeof data[0] === "function") {
                        data[0] = data[0]();
                    }
                    originalLog(level, data);
                };
            }
            return logger;
        } else {
            return new NativeLogger();
        }
    }
};
/**
 * Native logger that uses console.* functions
 */ let NativeLogger = class NativeLogger {
    /**
   * Supposed to log messages of trace level
   * @param {String|Function} message Message or message generator to log
   * @param {*[]} args Additional args to message
   */ trace(message, ...args) {
    // this logger does not print trace messages
    }
    /**
   * Supposed to log messages of debug level
   * @param {String|Function} message Message or message generator to log
   * @param {*[]} args Additional args to message
   */ debug(message, ...args) {
    // this logger does not print debug messages
    }
    /**
   * Prints a message with console.log
   * @param {String|Function} message Message or message generator to log
   * @param {*[]} args Additional args to message
   */ info(message, ...args) {
        this._log("log", message, args);
    }
    /**
   * Prints a message with console.warn
   * @param {String|Function} message Message or message generator to log
   * @param {*[]} args Additional args to message
   */ warn(message, ...args) {
        this._log("warn", message, args);
    }
    /**
   * Prints a message with console.error
   * @param {String|Function} message Message or message generator to log
   * @param {*[]} args Additional args to message
   */ error(message, ...args) {
        this._log("error", message, args);
    }
    /**
   * Prints a message with console.error
   * @param {String|Function} message Message or message generator to log
   * @param {*[]} args Additional args to message
   */ fatal(message, ...args) {
        this._log("error", message, args);
    }
    _log(level, message, args) {
        if (typeof message === "function") {
            message = message();
        }
        console[level](`[${new Date().toISOString()}] ${message}`, ...args);
    }
};
const _default = LoggerManager;

//# sourceMappingURL=data:application/json;base64,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