'use strict';
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
        var info = gen[key](arg);
        var value = info.value;
    } catch (error) {
        reject(error);
        return;
    }
    if (info.done) {
        resolve(value);
    } else {
        Promise.resolve(value).then(_next, _throw);
    }
}
function _async_to_generator(fn) {
    return function() {
        var self = this, args = arguments;
        return new Promise(function(resolve, reject) {
            var gen = fn.apply(self, args);
            function _next(value) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
            }
            function _throw(err) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
            }
            _next(undefined);
        });
    };
}
import MetaApiClient from '../metaApi.client';
import LoggerManager from '../../logger';
import { NotFoundError } from '../errorHandler';
let ClientApiClient = class ClientApiClient extends MetaApiClient {
    /**
   * Type hashing ignored field lists
   * @typedef {Object} TypeHashingIgnoredFieldLists
   * @property {String[]} specification specification ignored fields
   * @property {String[]} position position ignored fields
   * @property {String[]} order order ignored fields
   */ /**
   * Hashing ignored field lists
   * @typedef {Object} HashingIgnoredFieldLists
   * @property {TypeHashingIgnoredFieldLists} g1 g1 hashing ignored field lists
   * @property {TypeHashingIgnoredFieldLists} g2 g2 hashing ignored field lists
   */ /**
   * Refreshes hashing ignored field lists
   * @param {String} region account region
   * @returns {Promise} promise resolving when the hashing field lists are updated.
   */ refreshIgnoredFieldLists(region) {
        var _this = this;
        return _async_to_generator(function*() {
            if (_this._ignoredFieldListsCaches[region] && _this._ignoredFieldListsCaches[region].requestPromise) {
                yield _this._ignoredFieldListsCaches[region].requestPromise;
            } else if (_this._ignoredFieldListsCaches[region] && Date.now() - _this._ignoredFieldListsCaches[region].lastUpdated < _this._updateInterval) {
                return;
            } else {
                if (!_this._ignoredFieldListsCaches[region]) {
                    _this._ignoredFieldListsCaches[region] = {
                        lastUpdated: 0,
                        data: null,
                        requestPromise: null,
                        updateJob: setInterval(()=>_this._refreshIgnoredFieldListsJob(region), 60000)
                    };
                }
                let resolve, reject;
                _this._ignoredFieldListsCaches[region].requestPromise = new Promise((res, rej)=>{
                    resolve = res, reject = rej;
                });
                let isCacheUpdated = false;
                while(!isCacheUpdated){
                    try {
                        const host = yield _this._domainClient.getUrl(_this._host, region);
                        const opts = {
                            url: `${host}/hashing-ignored-field-lists`,
                            method: 'GET',
                            json: true,
                            headers: {
                                'auth-token': _this._token
                            }
                        };
                        const response = yield _this._httpClient.request(opts, 'getHashingIgnoredFieldLists');
                        _this._ignoredFieldListsCaches[region] = {
                            lastUpdated: Date.now(),
                            data: response,
                            requestPromise: null
                        };
                        _this._ignoredFieldListsFreshestCache = response;
                        resolve(response);
                        isCacheUpdated = true;
                        _this._ignoredFieldListsCaches[region].retryIntervalInSeconds = _this._retryIntervalInSeconds;
                    } catch (err) {
                        _this._logger.error('Failed to update hashing ignored field list', err);
                        _this._ignoredFieldListsCaches[region].retryIntervalInSeconds = Math.min(_this._ignoredFieldListsCaches[region].retryIntervalInSeconds * 2, 300);
                        yield new Promise((res)=>setTimeout(res, _this._ignoredFieldListsCaches[region].retryIntervalInSeconds * 1000));
                    }
                }
            }
        })();
    }
    /**
   * Retrieves hashing ignored field lists
   * @param {String} region account region
   * @returns {HashingIgnoredFieldLists} promise resolving with hashing ignored field lists
   */ getHashingIgnoredFieldLists(region) {
        if (region === 'combined') {
            if (this._ignoredFieldListsFreshestCache) {
                return this._ignoredFieldListsFreshestCache;
            } else {
                throw new NotFoundError('Ignored field lists not found');
            }
        }
        if (this._ignoredFieldListsCaches[region] && this._ignoredFieldListsCaches[region].data) {
            return this._ignoredFieldListsCaches[region].data;
        } else {
            throw new NotFoundError(`Ignored field lists for region ${region} not found`);
        }
    }
    _refreshIgnoredFieldListsJob(region) {
        var _this = this;
        return _async_to_generator(function*() {
            if (!_this._ignoredFieldListsCaches[region].requestPromise && Date.now() - _this._ignoredFieldListsCaches[region].lastUpdated > _this._updateInterval) {
                yield _this.refreshIgnoredFieldLists(region);
            }
        })();
    }
    /**
   * Constructs client API client instance
   * @param {HttpClient} httpClient HTTP client
   * @param {DomainClient} domainClient domain client
   */ constructor(httpClient, domainClient){
        super(httpClient, domainClient);
        this._host = 'https://mt-client-api-v1';
        this._retryIntervalInSeconds = 1;
        this._updateInterval = 60 * 60 * 1000;
        this._ignoredFieldListsCaches = {};
        this._ignoredFieldListsFreshestCache = null;
        this._logger = LoggerManager.getLogger('ClientApiClient');
    }
};
/**
 * metaapi.cloud client API client (see https://metaapi.cloud/docs/client/)
 */ export { ClientApiClient as default };

//# sourceMappingURL=data:application/json;base64,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