'use strict';
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
        var info = gen[key](arg);
        var value = info.value;
    } catch (error) {
        reject(error);
        return;
    }
    if (info.done) {
        resolve(value);
    } else {
        Promise.resolve(value).then(_next, _throw);
    }
}
function _async_to_generator(fn) {
    return function() {
        var self = this, args = arguments;
        return new Promise(function(resolve, reject) {
            var gen = fn.apply(self, args);
            function _next(value) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
            }
            function _throw(err) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
            }
            _next(undefined);
        });
    };
}
import MetaApiClient from '../metaApi.client';
import { NotFoundError } from '../errorHandler';
let HistoricalMarketDataClient = class HistoricalMarketDataClient extends MetaApiClient {
    /**
   * Returns historical candles for a specific symbol and timeframe from a MetaTrader account.
   * See https://metaapi.cloud/docs/client/restApi/api/retrieveMarketData/readHistoricalCandles/
   * @param {string} accountId MetaTrader account id
   * @param {string} region account region
   * @param {string} symbol symbol to retrieve candles for (e.g. a currency pair or an index)
   * @param {string} timeframe defines the timeframe according to which the candles must be generated. Allowed values
   * for MT5 are 1m, 2m, 3m, 4m, 5m, 6m, 10m, 12m, 15m, 20m, 30m, 1h, 2h, 3h, 4h, 6h, 8h, 12h, 1d, 1w, 1mn. Allowed
   * values for MT4 are 1m, 5m, 15m 30m, 1h, 4h, 1d, 1w, 1mn
   * @param {Date} [startTime] time to start loading candles from. Note that candles are loaded in backwards direction, so
   * this should be the latest time. Leave empty to request latest candles.
   * @param {number} [limit] maximum number of candles to retrieve. Must be less or equal to 1000
   * @return {Promise<Array<MetatraderCandle>>} promise resolving with historical candles downloaded
   */ getHistoricalCandles(accountId, region, symbol, timeframe, startTime, limit) {
        var _this = this;
        return _async_to_generator(function*() {
            symbol = encodeURIComponent(symbol);
            const host = yield _this._domainClient.getUrl(_this._host, region);
            const opts = {
                url: `${host}/users/current/accounts/${accountId}/historical-market-data/symbols/${symbol}/` + `timeframes/${timeframe}/candles`,
                method: 'GET',
                params: {
                    startTime,
                    limit
                },
                headers: {
                    'auth-token': _this._token
                },
                json: true
            };
            let candles = yield _this._httpClient.request(opts, 'getHistoricalCandles');
            candles = candles || [];
            candles.forEach((c)=>c.time = new Date(c.time));
            return candles;
        })();
    }
    /**
   * Returns historical ticks for a specific symbol from a MetaTrader account. This API is not supported by MT4
   * accounts.
   * See https://metaapi.cloud/docs/client/restApi/api/retrieveMarketData/readHistoricalTicks/
   * @param {string} accountId MetaTrader account id
   * @param {string} region account region
   * @param {string} symbol symbol to retrieve ticks for (e.g. a currency pair or an index)
   * @param {Date} [startTime] time to start loading ticks from. Note that candles are loaded in forward direction, so
   * this should be the earliest time. Leave empty to request latest candles.
   * @param {number} [offset] number of ticks to skip (you can use it to avoid requesting ticks from previous request
   * twice)
   * @param {number} [limit] maximum number of ticks to retrieve. Must be less or equal to 1000
   * @return {Promise<Array<MetatraderTick>>} promise resolving with historical ticks downloaded
   */ getHistoricalTicks(accountId, region, symbol, startTime, offset, limit) {
        var _this = this;
        return _async_to_generator(function*() {
            symbol = encodeURIComponent(symbol);
            const host = yield _this._domainClient.getUrl(_this._host, region);
            const opts = {
                url: `${host}/users/current/accounts/${accountId}/historical-market-data/symbols/${symbol}/ticks`,
                method: 'GET',
                params: {
                    startTime,
                    offset,
                    limit
                },
                headers: {
                    'auth-token': _this._token
                },
                json: true
            };
            let ticks = yield _this._httpClient.request(opts, 'getHistoricalTicks');
            ticks = ticks || [];
            ticks.forEach((t)=>t.time = new Date(t.time));
            return ticks;
        })();
    }
    /**
   * Constructs historical market data API client instance
   * @param {HttpClient} httpClient HTTP client
   * @param {DomainClient} domainClient domain client
   */ constructor(httpClient, domainClient){
        super(httpClient, domainClient);
        this._host = 'https://mt-market-data-client-api-v1';
    }
};
/**
 * metaapi.cloud historical market data API client
 */ export { HistoricalMarketDataClient as default };

//# sourceMappingURL=data:application/json;base64,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