'use strict';
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
        var info = gen[key](arg);
        var value = info.value;
    } catch (error) {
        reject(error);
        return;
    }
    if (info.done) {
        resolve(value);
    } else {
        Promise.resolve(value).then(_next, _throw);
    }
}
function _async_to_generator(fn) {
    return function() {
        var self = this, args = arguments;
        return new Promise(function(resolve, reject) {
            var gen = fn.apply(self, args);
            function _next(value) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
            }
            function _throw(err) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
            }
            _next(undefined);
        });
    };
}
let HistoryDatabase = class HistoryDatabase {
    /**
   * Returns history database instance
   * @returns {HistoryDatabase} history database instance
   */ static getInstance() {}
    /**
   * Loads history from database
   * @param {string} accountId account id
   * @param {string} application application name
   * @return {Promise<{deals: Array<MetatraderDeal>, historyOrders: Array<MetatraderOrder>}>} full account history
   */ loadHistory(accountId, application) {
        return _async_to_generator(function*() {})();
    }
    /**
   * Removes history from database
   * @param {string} accountId account id
   * @param {string} application application name
   * @return {Promise} promise resolving when the history is removed
   */ clear(accountId, application) {
        return _async_to_generator(function*() {})();
    }
    /**
   * Flushes the new history to db
   * @param {string} accountId account id
   * @param {string} application application name
   * @param {Array<MetatraderOrder>} newHistoryOrders history orders to save to db
   * @param {Array<MetatraderDeal>} newDeals deals to save to db
   * @return {Promise} promise resolving when the history is flushed
   */ flush(accountId, application, newHistoryOrders, newDeals) {
        return _async_to_generator(function*() {})();
    }
};
/**
 * Provides access to history database
 */ export { HistoryDatabase as default };

//# sourceMappingURL=data:application/json;base64,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