/* jscs:disable */ /* eslint-disable */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return _default;
    }
});
function createNewNode_(key) {
    return {
        key: key,
        weight: 1,
        height: 0,
        left: null,
        right: null
    };
}
var comparer_ = function(a, b) {
    if (a < b) return -1;
    if (a > b) return 1;
    return 0;
};
function height_(p) {
    return p ? p.height : 0;
}
function weight_(p) {
    return p ? p.weight : 0;
}
function bFactor_(p) {
    return height_(p.right) - height_(p.left);
}
function countHeightAndWeight_(p) {
    var hl = height_(p.left);
    var hr = height_(p.right);
    p.height = (hl > hr ? hl : hr) + 1;
    var wl = weight_(p.left);
    var wr = weight_(p.right);
    p.weight = wl + wr + 1;
}
function rotateRight_(p) {
    var q = p.left;
    p.left = q.right;
    q.right = p;
    countHeightAndWeight_(p);
    countHeightAndWeight_(q);
    return q;
}
function rotateLeft_(q) {
    var p = q.right;
    q.right = p.left;
    p.left = q;
    countHeightAndWeight_(q);
    countHeightAndWeight_(p);
    return p;
}
function balance_(p) {
    countHeightAndWeight_(p);
    if (bFactor_(p) === 2) {
        if (bFactor_(p.right) < 0) p.right = rotateRight_(p.right);
        return rotateLeft_(p);
    }
    if (bFactor_(p) === -2) {
        if (bFactor_(p.left) > 0) p.left = rotateLeft_(p.left);
        return rotateRight_(p);
    }
    return p;
}
function count_(p, k) {
    return upperBound_(p, k) - lowerBound_(p, k);
}
function at_(p, k) {
    if (!p) return null;
    var wl = weight_(p.left);
    if (wl <= k && k < wl + 1) return p.key;
    else if (k < wl) return at_(p.left, k);
    else return at_(p.right, k - wl - 1);
}
function getMinimum_(p) {
    if (!p) return null;
    return p.left ? getMinimum_(p.left) : p;
}
function getMaximum_(p) {
    if (!p) return null;
    return p.right ? getMaximum_(p.right) : p;
}
function removeMinimun_(p) {
    if (!p.left) return p.right;
    p.left = removeMinimun_(p.left);
    return balance_(p);
}
function toArray_(p) {
    var arr = [];
    if (p.left) arr = arr.concat(toArray_(p.left));
    arr.push(p.key);
    if (p.right) arr = arr.concat(toArray_(p.right));
    return arr;
}
var AVLTree = function(comparer) {
    if (!comparer) comparer = comparer_;
    var AVL = {
        root: null,
        comparer_: comparer,
        size: function() {
            return weight_(AVL.root);
        },
        min: function() {
            var p = getMinimum_(AVL.root);
            if (p) return p.key;
            return null;
        },
        max: function() {
            var p = getMaximum_(AVL.root);
            if (p) return p.key;
            return null;
        },
        lowerBound: function(k) {
            return AVL.lowerBound_(AVL.root, k);
        },
        lowerBound_ (p, k) {
            if (!p) return 0;
            var cmp = AVL.comparer_(k, p.key);
            if (cmp <= 0) return AVL.lowerBound_(p.left, k);
            else if (cmp > 0) return weight_(p.left) + AVL.lowerBound_(p.right, k) + 1;
        },
        upperBound: function(k) {
            return AVL.upperBound_(AVL.root, k);
        },
        upperBound_ (p, k) {
            if (!p) return 0;
            var cmp = AVL.comparer_(k, p.key);
            if (cmp < 0) return AVL.upperBound_(p.left, k);
            else if (cmp >= 0) return weight_(p.left) + AVL.upperBound_(p.right, k) + 1;
        },
        count: function(k) {
            return count_(AVL.root, k);
        },
        at: function(k) {
            return at_(AVL.root, k);
        },
        insert: function(k) {
            AVL.root = AVL.insert_(AVL.root, k);
        },
        insert_ (p, k) {
            if (!p) return createNewNode_(k);
            var cmp = AVL.comparer_(k, p.key);
            if (cmp < 0) p.left = AVL.insert_(p.left, k);
            else if (cmp >= 0) p.right = AVL.insert_(p.right, k);
            return balance_(p);
        },
        remove: function(k) {
            AVL.root = AVL.remove_(AVL.root, k);
        },
        remove_ (p, k) {
            if (!p) return null;
            var cmp = AVL.comparer_(k, p.key);
            if (cmp < 0) p.left = AVL.remove_(p.left, k);
            else if (cmp > 0) p.right = AVL.remove_(p.right, k);
            else {
                var q = p.left;
                var r = p.right;
                if (!r) return q;
                var min = getMinimum_(r);
                min.right = removeMinimun_(r);
                min.left = q;
                return balance_(min);
            }
            return balance_(p);
        },
        removeAt: function(k) {
            var val = AVL.at(k);
            AVL.root = AVL.remove_(AVL.root, val);
        },
        toArray: function() {
            if (AVL.root === null) return [];
            return toArray_(AVL.root);
        }
    };
    return AVL;
};
const _default = AVLTree;

//# sourceMappingURL=data:application/json;base64,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