"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return RiskManagement;
    }
});
const _httpClient = /*#__PURE__*/ _interop_require_default(require("./clients/httpClient"));
const _equityTrackingclient = /*#__PURE__*/ _interop_require_default(require("./clients/equityTracking/equityTracking.client"));
const _domainclient = /*#__PURE__*/ _interop_require_default(require("./clients/domain.client"));
const _metaApi = /*#__PURE__*/ _interop_require_default(require("../metaApi/metaApi"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let RiskManagement = class RiskManagement {
    /**
   * Returns RiskManagement equity tracking API
   * @returns {EquityTrackingClient} tracking API
   */ get riskManagementApi() {
        return this._equityTrackingClient;
    }
    /**
   * Risk management SDK options
   * @typedef RiskManagementOptions
   * @property {String} [domain] domain to connect to
   * @property {Number} [requestTimeout] timeout for http requests in seconds
   * @property {Number} [extendedTimeout] timeout for extended http requests in seconds
   * @property {RetryOptions} [retryOpts] retry options for http requests
   */ /**
   * Constructs class instance
   * @param {String} token authorization API token (access tokens are not supported)
   * @param {RiskManagementOptions} opts connection options
   */ constructor(token, opts = {}){
        const metaApi = new _metaApi.default(token, opts);
        this._domain = opts.domain || "agiliumtrade.agiliumtrade.ai";
        let requestTimeout = opts.requestTimeout || 10;
        let requestExtendedTimeout = opts.extendedTimeout || 70;
        let retryOpts = opts.retryOpts || {};
        this._httpClient = new _httpClient.default(requestTimeout, requestExtendedTimeout, retryOpts);
        this._domainClient = new _domainclient.default(this._httpClient, token, "risk-management-api-v1", this._domain);
        this._equityTrackingClient = new _equityTrackingclient.default(this._domainClient, metaApi);
    }
};

//# sourceMappingURL=data:application/json;base64,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