<!DOCTYPE html>
<html lang="en" class="scroll-smooth">

<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="cPatUqlMGUGsDVhMZWsInpTNwafyjt1ByHh1MJT0">
    <meta name="description" content="<?php echo e($settings->site_name); ?> is one of the fastest growing online trading brands in the world. Voted the best mobile trading platform">
    <link rel="icon" type="image/png" href="<?php echo e(asset('storage/app/public/'.$settings->favicon)); ?>">
    <title><?php echo e($settings->site_name); ?>- Your Trusted Trading Platform</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net/">
    <link href="https://fonts.bunny.net/css?family=playfair-display:400,500,600,700|montserrat:300,400,500,600,700&amp;display=swap" rel="stylesheet" />

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com/"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Montserrat', 'sans-serif'],
                        display: ['Playfair Display', 'serif'],
                    },
                    colors: {
                        horizon: {
                            50: '#f0f9f5',
                            100: '#daf0e5',
                            200: '#b6e0cc',
                            300: '#84c7a9',
                            400: '#4fa980',
                            500: '#2a8c61',
                            600: '#1e704e',
                            700: '#1a5a40', // Dark green for navigation
                            800: '#184835',
                            900: '#153c2d',
                            950: '#0c2119',
                        },
                        gold: {
                            400: '#fcd34d',
                            500: '#fcb529',
                            600: '#f59e0b',
                        },
                        secondary: {
                            50: '#f8fafc',
                            100: '#f1f5f9',
                            200: '#e2e8f0',
                            300: '#cbd5e1',
                            400: '#94a3b8',
                            500: '#64748b',
                            600: '#475569',
                            700: '#334155',
                            800: '#1e293b',
                            900: '#0f172a',
                            950: '#020617',
                        },
                    },
                    animation: {
                        'fade-in': 'fadeIn 0.5s ease-in-out',
                        'slide-up': 'slideUp 0.5s ease-out',
                        'slide-down': 'slideDown 0.3s ease-out',
                        'scale': 'scale 0.3s ease-in-out',
                    },
                    keyframes: {
                        fadeIn: {
                            '0%': { opacity: '0' },
                            '100%': { opacity: '1' },
                        },
                        slideUp: {
                            '0%': { transform: 'translateY(10px)', opacity: '0' },
                            '100%': { transform: 'translateY(0)', opacity: '1' },
                        },
                        slideDown: {
                            '0%': { transform: 'translateY(-10px)', opacity: '0' },
                            '100%': { transform: 'translateY(0)', opacity: '1' },
                        },
                        scale: {
                            '0%': { transform: 'scale(0.95)', opacity: '0' },
                            '100%': { transform: 'scale(1)', opacity: '1' },
                        },
                    },
                },
            },
        }
    </script>

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <style>
        [x-cloak] { display: none !important; }

        /* Smooth scrolling */
        html {
            scroll-behavior: smooth;
        }

        /* Custom scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
            height: 8px;
        }

        ::-webkit-scrollbar-track {
            background: #f1f5f9;
        }

        ::-webkit-scrollbar-thumb {
            background: #94a3b8;
            border-radius: 4px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: #64748b;
        }
    </style>
</head>
<body class="font-sans antialiased min-h-screen flex flex-col bg-white text-secondary-900">
    <!-- WhatsApp Button -->
    <?php if(!empty($settings->whatsapp)): ?>
    <a href="https://wa.me/qr/<?php echo e($settings->whatsapp); ?>"
       target="_blank"
       rel="noopener noreferrer"
       class="fixed bottom-4 left-4 bg-green-500 text-white p-3 rounded-full shadow-lg hover:bg-green-600 transition-colors duration-300 z-50">
        <svg
            xmlns="http://www.w3.org/2000/svg"
            class="h-6 w-6"
            viewBox="0 0 24 24"
            fill="currentColor">
            <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/>
        </svg>
    </a>
    <?php endif; ?>

    <!-- Header -->
    <header class="sticky top-0 z-50 transition-all duration-300 bg-horizon-700">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Top Bar -->
            <div class="hidden md:flex items-center justify-between py-2 text-white text-sm border-b border-horizon-600/30">
                <div class="flex items-center space-x-6">
                    
                    <a href="#" class="flex items-center hover:text-gray-200 transition-colors duration-200">
                        <i class="fas fa-envelope mr-2"></i> <span class="__cf_email__" data-cfemail="15666065657a67615570797c61707770617462707479617d3b767a78"><?php echo e($settings->contact_email); ?></span>
                    </a>
                    <div class="flex items-center">
                        <i class="fas fa-map-marker-alt mr-2"></i> <?php echo e($settings->address_o); ?>

                    </div>
                </div>
                <div class="flex items-center space-x-6">
                    <a href="contact" class="hover:text-gray-200 transition-colors duration-200">Support</a>
                    <a href="contact" class="hover:text-gray-200 transition-colors duration-200">Help</a>
                </div>
            </div>

            <!-- Main Navigation -->
            <div class="flex items-center justify-between h-20">
                <!-- Logo -->
                <a href="index" class="flex-shrink-0">
                    <span class="font-display text-3xl font-bold text-white tracking-widest">
                        <?php echo e($settings->site_name); ?>

                    </span>
                </a>

                <!-- Desktop Navigation -->
                <nav class="hidden md:flex items-center space-x-8">
                    <a href="index" class="text-white hover:text-gray-200 text-base font-medium tracking-wide transition-colors duration-200">
                        Home
                    </a>
                    <a href="about" class="text-white hover:text-gray-200 text-base font-medium tracking-wide transition-colors duration-200">
                        About Us
                    </a>
                    <a href="services" class="text-white hover:text-gray-200 text-base font-medium tracking-wide transition-colors duration-200">
                        Services
                    </a>
                    <a href="contact" class="text-white hover:text-gray-200 text-base font-medium tracking-wide transition-colors duration-200">
                        Contact Us
                    </a>
                </nav>

                <!-- verify Button (Desktop) -->
                <div class="hidden md:block">
                    <a href="verify" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-horizon-700 bg-gold-500 hover:bg-gold-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gold-500 transition-colors duration-200">
                        Register Now
                    </a>
                </div>

                <!-- Login Button (Desktop) -->
                <div class="hidden md:block ml-4">
                    <a href="login" class="inline-flex items-center px-4 py-2 border border-white text-sm font-medium rounded-md text-white hover:bg-horizon-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-horizon-500 transition-colors duration-200">
                        Login
                    </a>
                </div>

                <!-- Mobile Menu Button -->
                <div class="md:hidden">
                    <button id="mobile-menu-button" class="text-white hover:text-gray-200 focus:outline-none">
                        <svg class="h-6 w-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                    </button>
                </div>
            </div>
        </div>

        <!-- Mobile Menu -->
        <div id="mobile-menu" class="md:hidden bg-horizon-700 shadow-lg hidden">
            <div class="px-2 pt-2 pb-3 space-y-1">
                <a href="index" class="block px-3 py-2 rounded-md text-base font-medium text-white hover:bg-horizon-600 transition-colors duration-200">
                    Home
                </a>
                <a href="about" class="block px-3 py-2 rounded-md text-base font-medium text-white hover:bg-horizon-600 transition-colors duration-200">
                    About Us
                </a>
                <a href="services" class="block px-3 py-2 rounded-md text-base font-medium text-white hover:bg-horizon-600 transition-colors duration-200">
                    Services
                </a>

                <a href="contact" class="block px-3 py-2 rounded-md text-base font-medium text-white hover:bg-horizon-600 transition-colors duration-200">
                    Contact Us
                </a>
                <div class="pt-4">
                    <a href="verify" class="block w-full text-center px-3 py-2 rounded-md text-base font-medium text-horizon-700 bg-gold-500 hover:bg-gold-600 transition-colors duration-200">
                        Register Now
                    </a>
                </div>
                <div class="pt-2">
                    <a href="login" class="block w-full text-center px-3 py-2 rounded-md text-base font-medium text-white border border-white hover:bg-horizon-600 transition-colors duration-200">
                        Login
                    </a>
                </div>
            </div>
        </div>
    </header>


    <?php echo $__env->yieldContent('content'); ?>

      <!-- Toast Notification -->
    <div id="toast" class="hidden fixed bottom-10 right-10 z-50 p-4 bg-white text-black rounded-lg shadow-lg border border-gold-500 max-w-md"></div>

    <!-- Footer -->
    <footer class="bg-gray-100 mt-16">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-12">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                <!-- Company Info -->
                <div class="col-span-1 md:col-span-2 lg:col-span-1">
                    <a href="index" class="inline-block mb-6">
                        <span class="font-display text-2xl font-bold text-horizon-700">
                            <?php echo e($settings->site_name); ?>

                        </span>
                    </a>
                    <p class="text-secondary-600 mb-6">
                        <?php echo e($settings->site_name); ?> is a leading cryptocurrency trading platform, providing users with the ability to buy, sell, and trade various digital assets. As a decentralized platform, <?php echo e($settings->site_name); ?> empowers users to navigate the dynamic world of cryptocurrencies seamlessly.
                    </p>
                    <div class="flex space-x-4">
                        <a href="https://facebook.com/" target="_blank" class="text-horizon-600 hover:text-horizon-700 transition-colors duration-200">
                            <i class="fab fa-facebook-f"></i>
                        </a>
                        <a href="https://twitter.com/" target="_blank" class="text-horizon-600 hover:text-horizon-700 transition-colors duration-200">
                            <i class="fab fa-twitter"></i>
                        </a>
                        <a href="https://linkedin.com/" target="_blank" class="text-horizon-600 hover:text-horizon-700 transition-colors duration-200">
                            <i class="fab fa-linkedin-in"></i>
                        </a>
                        <a href="https://instagram.com/" target="_blank" class="text-horizon-600 hover:text-horizon-700 transition-colors duration-200">
                            <i class="fab fa-instagram"></i>
                        </a>
                    </div>
                </div>

                <!-- Our Company -->
                <div>
                    <h3 class="text-lg font-semibold text-horizon-700 mb-6">Our Company</h3>
                    <ul class="space-y-4">
                        <li>
                            <a href="about" class="text-secondary-600 hover:text-horizon-600 transition-colors duration-200 flex items-center">
                                <i class="fas fa-chevron-right text-xs mr-2"></i>
                                Company & Team
                            </a>
                        </li>
                        <li>
                            <a href="services" class="text-secondary-600 hover:text-horizon-600 transition-colors duration-200 flex items-center">
                                <i class="fas fa-chevron-right text-xs mr-2"></i>
                                Our Services
                            </a>
                        </li>
                        <li>
                            <a href="contact" class="text-secondary-600 hover:text-horizon-600 transition-colors duration-200 flex items-center">
                                <i class="fas fa-chevron-right text-xs mr-2"></i>
                                Contact Us
                            </a>
                        </li>
                        <li>
                            <a href="terms" class="text-secondary-600 hover:text-horizon-600 transition-colors duration-200 flex items-center">
                                <i class="fas fa-chevron-right text-xs mr-2"></i>
                                Privacy Policy
                            </a>
                        </li>
                    </ul>
                </div>

                <!-- Products -->
                <div>
                    <h3 class="text-lg font-semibold text-horizon-700 mb-6">Products</h3>
                    <ul class="space-y-4">
                        <li>
                            <a href="services" class="text-secondary-600 hover:text-horizon-600 transition-colors duration-200 flex items-center">
                                <i class="fas fa-chevron-right text-xs mr-2"></i>
                                Online Payment
                            </a>
                        </li>
                        <li>
                            <a href="services" class="text-secondary-600 hover:text-horizon-600 transition-colors duration-200 flex items-center">
                                <i class="fas fa-chevron-right text-xs mr-2"></i>
                                Deposit Skim
                            </a>
                        </li>
                        <li>
                            <a href="services" class="text-secondary-600 hover:text-horizon-600 transition-colors duration-200 flex items-center">
                                <i class="fas fa-chevron-right text-xs mr-2"></i>
                                Online Shopping
                            </a>
                        </li>
                        <li>
                            <a href="services" class="text-secondary-600 hover:text-horizon-600 transition-colors duration-200 flex items-center">
                                <i class="fas fa-chevron-right text-xs mr-2"></i>
                                Master Card
                            </a>
                        </li>
                        <li>
                            <a href="services" class="text-secondary-600 hover:text-horizon-600 transition-colors duration-200 flex items-center">
                                <i class="fas fa-chevron-right text-xs mr-2"></i>
                                Receive Money
                            </a>
                        </li>
                    </ul>
                </div>

                <!-- Subscribe -->
                <div>
                    <h3 class="text-lg font-semibold text-horizon-700 mb-6">Subscribe</h3>
                    <p class="text-secondary-600 mb-4">Get regular updates from us</p>
                    <form action="#" class="flex">
                        <input type="email" placeholder="Your Email" class="px-4 py-2 w-full border border-secondary-300 rounded-l-md focus:outline-none focus:ring-2 focus:ring-horizon-500 focus:border-horizon-500">
                        <button type="button" class="px-4 py-2 bg-gold-500 text-horizon-700 font-medium rounded-r-md hover:bg-gold-600 focus:outline-none focus:ring-2 focus:ring-gold-500 focus:ring-offset-2 transition-colors duration-200">
                            Subscribe
                        </button>
                    </form>
                </div>
            </div>

            <!-- Copyright -->
            <div class="mt-12 pt-8 border-t border-secondary-200 text-center">
                <p class="text-secondary-600">&copy; 2025 <?php echo e($settings->site_name); ?>. All Rights Reserved</p>
            </div>
        </div>
    </footer>

    <!-- Back to top button -->
    <button
        id="back-to-top"
        class="fixed bottom-6 right-6 p-3 rounded-full bg-gold-500 text-horizon-700 shadow-lg transform transition-transform duration-300 hover:scale-110 focus:outline-none hidden"
    >
        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 10l7-7m0 0l7 7m-7-7v18" />
        </svg>
    </button>

    <script>
        // Mobile menu toggle
        $(document).ready(function() {
            $('#mobile-menu-button').click(function() {
                $('#mobile-menu').slideToggle();
            });

            // Back to top button
            $(window).scroll(function() {
                if ($(this).scrollTop() > 300) {
                    $('#back-to-top').fadeIn();
                } else {
                    $('#back-to-top').fadeOut();
                }
            });

            $('#back-to-top').click(function() {
                $('html, body').animate({scrollTop: 0}, 800);
                return false;
            });

            // Toast notification system
            window.showToast = function(message, duration = 3000) {
                const toast = $('#toast');
                toast.text(message);
                toast.removeClass('hidden').addClass('block');

                setTimeout(function() {
                    toast.removeClass('block').addClass('hidden');
                }, duration);
            };

            // Random transaction notifications
            const amounts = [30000, 45000, 11500, 16000, 8000, 10000, 13000, 17000, 29000, 30000, 16000, 28000, 21000, 51000, 12000, 17000, 25000, 9000, 50000, 4000];
            const countries = [
                "United States", "United Kingdom", "Canada", "Australia", "Germany",
                "France", "Japan", "China", "Brazil", "India", "Russia", "South Africa",
                "Mexico", "Spain", "Italy", "Netherlands", "Sweden", "Singapore",
                "United Arab Emirates", "Switzerland"
            ];

            function showRandomTransaction() {
                const isInvestment = Math.random() < 0.5;
                const randomCountry = countries[Math.floor(Math.random() * countries.length)];
                const randomAmount = amounts[Math.floor(Math.random() * amounts.length)];

                let message;
                if (isInvestment) {
                    message = `Someone from ${randomCountry} just invested $${randomAmount} in <?php echo e($settings->site_name); ?>`;
                } else {
                    message = `Someone from ${randomCountry} just withdrew $${randomAmount} from <?php echo e($settings->site_name); ?>`;
                }

                window.showToast(message, 3000);
            }

            // Show random transactions every 10 seconds
            setInterval(showRandomTransaction, 10000);
        });
    </script>
    <?php echo $__env->make('layouts.livechat', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>


</html>
<?php /**PATH C:\xampp\htdocs\brembypro\resources\views/layouts/base.blade.php ENDPATH**/ ?>