

<?php $__env->startSection('title', 'Crypto Orders'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
    <!-- Header -->
    <div class="mb-6 flex items-center justify-between flex-wrap gap-3">
        <div class="min-w-0 flex-1">
            <h1 class="text-xl sm:text-2xl md:text-3xl font-bold text-white">Crypto Orders</h1>
            <p class="text-xs sm:text-sm text-gray-400 mt-1">View and manage your cryptocurrency orders</p>
        </div>
        <a href="<?php echo e(route('crypto-trading.index')); ?>" class="bg-primary-500 hover:bg-primary-600 text-white px-3 sm:px-4 py-1.5 sm:py-2 rounded-lg text-sm sm:text-base flex items-center space-x-2 transition-colors duration-150 whitespace-nowrap flex-shrink-0">
            <i data-lucide="arrow-left" class="w-4 h-4 sm:w-5 sm:h-5"></i>
            <span>Back to Trading</span>
        </a>
    </div>

    <?php if(session('success')): ?>
    <div class="bg-green-500/10 border border-green-500/20 text-green-400 px-4 py-3 rounded-lg mb-6">
        <?php echo e(session('success')); ?>

    </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
    <div class="bg-red-500/10 border border-red-500/20 text-red-400 px-4 py-3 rounded-lg mb-6">
        <?php echo e(session('error')); ?>

    </div>
    <?php endif; ?>

    <!-- Order Tabs -->
    <div class="bg-gradient-to-br from-gray-900 to-gray-800 border border-gray-700 rounded-xl shadow-xl overflow-hidden">
        <div class="flex border-b border-gray-700">
            <button onclick="showTab('active')" id="activeTab" class="flex-1 px-6 py-4 text-white font-semibold border-b-2 border-primary-500 bg-gray-800/50">
                <div class="flex items-center justify-center space-x-2">
                    <i data-lucide="clock" class="w-5 h-5"></i>
                    <span>Active Orders (<?php echo e($activeOrders->count()); ?>)</span>
                </div>
            </button>
            <button onclick="showTab('completed')" id="completedTab" class="flex-1 px-6 py-4 text-gray-400 font-semibold hover:bg-gray-800/30 transition-colors duration-150">
                <div class="flex items-center justify-center space-x-2">
                    <i data-lucide="check-circle" class="w-5 h-5"></i>
                    <span>Completed (<?php echo e($completedOrders->count()); ?>)</span>
                </div>
            </button>
            <button onclick="showTab('cancelled')" id="cancelledTab" class="flex-1 px-6 py-4 text-gray-400 font-semibold hover:bg-gray-800/30 transition-colors duration-150">
                <div class="flex items-center justify-center space-x-2">
                    <i data-lucide="x-circle" class="w-5 h-5"></i>
                    <span>Cancelled (<?php echo e($cancelledOrders->count()); ?>)</span>
                </div>
            </button>
        </div>

        <!-- Active Orders Content -->
        <div id="activeContent" class="p-5">
            <?php if($activeOrders->isEmpty()): ?>
            <div class="text-center py-12">
                <i data-lucide="inbox" class="w-16 h-16 text-gray-600 mx-auto mb-4"></i>
                <p class="text-gray-400 text-lg mb-2">No active orders</p>
                <p class="text-gray-500 text-sm">All your pending orders will appear here</p>
            </div>
            <?php else: ?>
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="border-b border-gray-700">
                            <th class="text-left text-gray-400 text-sm font-semibold py-3 px-3">Cryptocurrency</th>
                            <th class="text-left text-gray-400 text-sm font-semibold py-3 px-3">Type</th>
                            <th class="text-left text-gray-400 text-sm font-semibold py-3 px-3">Order Type</th>
                            <th class="text-right text-gray-400 text-sm font-semibold py-3 px-3">Quantity</th>
                            <th class="text-right text-gray-400 text-sm font-semibold py-3 px-3">Target Price</th>
                            <th class="text-right text-gray-400 text-sm font-semibold py-3 px-3">Total</th>
                            <th class="text-left text-gray-400 text-sm font-semibold py-3 px-3">Date</th>
                            <th class="text-center text-gray-400 text-sm font-semibold py-3 px-3">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $activeOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="border-b border-gray-800 hover:bg-gray-800/30 transition-colors duration-150">
                            <td class="py-4 px-3">
                                <div class="flex items-center space-x-2">
                                    <?php if($order->cryptoPrice && $order->cryptoPrice->logo): ?>
                                    <img src="<?php echo e($order->cryptoPrice->logo); ?>" alt="<?php echo e($order->coin_symbol); ?>" class="w-8 h-8 rounded-full">
                                    <?php else: ?>
                                    <div class="w-8 h-8 rounded-full bg-primary-500/10 flex items-center justify-center">
                                        <i data-lucide="bitcoin" class="w-5 h-5 text-primary-500"></i>
                                    </div>
                                    <?php endif; ?>
                                    <div>
                                        <p class="text-white font-semibold"><?php echo e($order->coin_symbol); ?></p>
                                        <?php if($order->cryptoPrice): ?>
                                        <p class="text-gray-400 text-xs"><?php echo e($order->cryptoPrice->name); ?></p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                            <td class="py-4 px-3">
                                <span class="px-2 py-1 rounded text-xs font-semibold <?php echo e($order->trade_type === 'buy' ? 'bg-green-500/10 text-green-400' : 'bg-red-500/10 text-red-400'); ?>">
                                    <?php echo e(strtoupper($order->trade_type)); ?>

                                </span>
                            </td>
                            <td class="py-4 px-3">
                                <span class="px-2 py-1 rounded text-xs font-semibold bg-yellow-500/10 text-yellow-400">
                                    <?php echo e(ucfirst(str_replace('_', ' ', $order->order_type))); ?>

                                </span>
                            </td>
                            <td class="py-4 px-3 text-right text-white"><?php echo e(number_format($order->quantity, 8)); ?></td>
                            <td class="py-4 px-3 text-right text-white">$<?php echo e(number_format($order->limit_price ?? $order->stop_price, 2)); ?></td>
                            <td class="py-4 px-3 text-right text-white font-semibold">$<?php echo e(number_format($order->net_amount, 2)); ?></td>
                            <td class="py-4 px-3 text-gray-400 text-sm"><?php echo e($order->created_at->format('M d, Y H:i')); ?></td>
                            <td class="py-4 px-3 text-center">
                                <form action="<?php echo e(route('crypto-trading.order.cancel', $order->id)); ?>" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to cancel this order?')">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="bg-red-500/10 hover:bg-red-500/20 text-red-400 px-3 py-1 rounded-lg text-sm font-semibold transition-colors duration-150">
                                        Cancel
                                    </button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            
            <div class="mt-4">
                <?php echo e($activeOrders->links()); ?>

            </div>
            <?php endif; ?>
        </div>

        <!-- Completed Orders Content -->
        <div id="completedContent" class="p-5 hidden">
            <?php if($completedOrders->isEmpty()): ?>
            <div class="text-center py-12">
                <i data-lucide="inbox" class="w-16 h-16 text-gray-600 mx-auto mb-4"></i>
                <p class="text-gray-400 text-lg mb-2">No completed orders</p>
                <p class="text-gray-500 text-sm">Your completed trades will appear here</p>
            </div>
            <?php else: ?>
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="border-b border-gray-700">
                            <th class="text-left text-gray-400 text-sm font-semibold py-3 px-3">Cryptocurrency</th>
                            <th class="text-left text-gray-400 text-sm font-semibold py-3 px-3">Type</th>
                            <th class="text-left text-gray-400 text-sm font-semibold py-3 px-3">Order Type</th>
                            <th class="text-right text-gray-400 text-sm font-semibold py-3 px-3">Quantity</th>
                            <th class="text-right text-gray-400 text-sm font-semibold py-3 px-3">Price</th>
                            <th class="text-right text-gray-400 text-sm font-semibold py-3 px-3">Total</th>
                            <th class="text-left text-gray-400 text-sm font-semibold py-3 px-3">Completed Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $completedOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="border-b border-gray-800 hover:bg-gray-800/30 transition-colors duration-150">
                            <td class="py-4 px-3">
                                <div class="flex items-center space-x-2">
                                    <?php if($order->cryptoPrice && $order->cryptoPrice->logo): ?>
                                    <img src="<?php echo e($order->cryptoPrice->logo); ?>" alt="<?php echo e($order->coin_symbol); ?>" class="w-8 h-8 rounded-full">
                                    <?php else: ?>
                                    <div class="w-8 h-8 rounded-full bg-primary-500/10 flex items-center justify-center">
                                        <i data-lucide="bitcoin" class="w-5 h-5 text-primary-500"></i>
                                    </div>
                                    <?php endif; ?>
                                    <div>
                                        <p class="text-white font-semibold"><?php echo e($order->coin_symbol); ?></p>
                                        <?php if($order->cryptoPrice): ?>
                                        <p class="text-gray-400 text-xs"><?php echo e($order->cryptoPrice->name); ?></p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                            <td class="py-4 px-3">
                                <span class="px-2 py-1 rounded text-xs font-semibold <?php echo e($order->trade_type === 'buy' ? 'bg-green-500/10 text-green-400' : 'bg-red-500/10 text-red-400'); ?>">
                                    <?php echo e(strtoupper($order->trade_type)); ?>

                                </span>
                            </td>
                            <td class="py-4 px-3">
                                <span class="px-2 py-1 rounded text-xs font-semibold bg-blue-500/10 text-blue-400">
                                    <?php echo e(ucfirst(str_replace('_', ' ', $order->order_type))); ?>

                                </span>
                            </td>
                            <td class="py-4 px-3 text-right text-white"><?php echo e(number_format($order->quantity, 8)); ?></td>
                            <td class="py-4 px-3 text-right text-white">$<?php echo e(number_format($order->price_usd, 2)); ?></td>
                            <td class="py-4 px-3 text-right text-white font-semibold">$<?php echo e(number_format($order->net_amount, 2)); ?></td>
                            <td class="py-4 px-3 text-gray-400 text-sm"><?php echo e($order->completed_at ? $order->completed_at->format('M d, Y H:i') : 'N/A'); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            
            <div class="mt-4">
                <?php echo e($completedOrders->links()); ?>

            </div>
            <?php endif; ?>
        </div>

        <!-- Cancelled Orders Content -->
        <div id="cancelledContent" class="p-5 hidden">
            <?php if($cancelledOrders->isEmpty()): ?>
            <div class="text-center py-12">
                <i data-lucide="inbox" class="w-16 h-16 text-gray-600 mx-auto mb-4"></i>
                <p class="text-gray-400 text-lg mb-2">No cancelled orders</p>
                <p class="text-gray-500 text-sm">Cancelled orders will appear here</p>
            </div>
            <?php else: ?>
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="border-b border-gray-700">
                            <th class="text-left text-gray-400 text-sm font-semibold py-3 px-3">Cryptocurrency</th>
                            <th class="text-left text-gray-400 text-sm font-semibold py-3 px-3">Type</th>
                            <th class="text-left text-gray-400 text-sm font-semibold py-3 px-3">Order Type</th>
                            <th class="text-right text-gray-400 text-sm font-semibold py-3 px-3">Quantity</th>
                            <th class="text-right text-gray-400 text-sm font-semibold py-3 px-3">Target Price</th>
                            <th class="text-right text-gray-400 text-sm font-semibold py-3 px-3">Total</th>
                            <th class="text-left text-gray-400 text-sm font-semibold py-3 px-3">Cancelled Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $cancelledOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="border-b border-gray-800 hover:bg-gray-800/30 transition-colors duration-150">
                            <td class="py-4 px-3">
                                <div class="flex items-center space-x-2">
                                    <?php if($order->cryptoPrice && $order->cryptoPrice->logo): ?>
                                    <img src="<?php echo e($order->cryptoPrice->logo); ?>" alt="<?php echo e($order->coin_symbol); ?>" class="w-8 h-8 rounded-full">
                                    <?php else: ?>
                                    <div class="w-8 h-8 rounded-full bg-primary-500/10 flex items-center justify-center">
                                        <i data-lucide="bitcoin" class="w-5 h-5 text-primary-500"></i>
                                    </div>
                                    <?php endif; ?>
                                    <div>
                                        <p class="text-white font-semibold"><?php echo e($order->coin_symbol); ?></p>
                                        <?php if($order->cryptoPrice): ?>
                                        <p class="text-gray-400 text-xs"><?php echo e($order->cryptoPrice->name); ?></p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                            <td class="py-4 px-3">
                                <span class="px-2 py-1 rounded text-xs font-semibold bg-gray-500/10 text-gray-400">
                                    <?php echo e(strtoupper($order->trade_type)); ?>

                                </span>
                            </td>
                            <td class="py-4 px-3">
                                <span class="px-2 py-1 rounded text-xs font-semibold bg-gray-500/10 text-gray-400">
                                    <?php echo e(ucfirst(str_replace('_', ' ', $order->order_type))); ?>

                                </span>
                            </td>
                            <td class="py-4 px-3 text-right text-gray-400"><?php echo e(number_format($order->quantity, 8)); ?></td>
                            <td class="py-4 px-3 text-right text-gray-400">$<?php echo e(number_format($order->limit_price ?? $order->stop_price, 2)); ?></td>
                            <td class="py-4 px-3 text-right text-gray-400">$<?php echo e(number_format($order->net_amount, 2)); ?></td>
                            <td class="py-4 px-3 text-gray-400 text-sm"><?php echo e($order->updated_at->format('M d, Y H:i')); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            
            <div class="mt-4">
                <?php echo e($cancelledOrders->links()); ?>

            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function showTab(tabName) {
    // Hide all content
    document.getElementById('activeContent').classList.add('hidden');
    document.getElementById('completedContent').classList.add('hidden');
    document.getElementById('cancelledContent').classList.add('hidden');
    
    // Reset all tabs
    document.getElementById('activeTab').classList.remove('border-primary-500', 'bg-gray-800/50', 'text-white');
    document.getElementById('activeTab').classList.add('text-gray-400');
    document.getElementById('completedTab').classList.remove('border-primary-500', 'bg-gray-800/50', 'text-white');
    document.getElementById('completedTab').classList.add('text-gray-400');
    document.getElementById('cancelledTab').classList.remove('border-primary-500', 'bg-gray-800/50', 'text-white');
    document.getElementById('cancelledTab').classList.add('text-gray-400');
    
    // Show selected content and highlight tab
    if (tabName === 'active') {
        document.getElementById('activeContent').classList.remove('hidden');
        document.getElementById('activeTab').classList.add('border-primary-500', 'bg-gray-800/50', 'text-white');
        document.getElementById('activeTab').classList.remove('text-gray-400');
    } else if (tabName === 'completed') {
        document.getElementById('completedContent').classList.remove('hidden');
        document.getElementById('completedTab').classList.add('border-primary-500', 'bg-gray-800/50', 'text-white');
        document.getElementById('completedTab').classList.remove('text-gray-400');
    } else if (tabName === 'cancelled') {
        document.getElementById('cancelledContent').classList.remove('hidden');
        document.getElementById('cancelledTab').classList.add('border-primary-500', 'bg-gray-800/50', 'text-white');
        document.getElementById('cancelledTab').classList.remove('text-gray-400');
    }
    
    // Reinitialize Lucide icons
    if (typeof lucide !== 'undefined') {
        lucide.createIcons();
    }
}

// Initialize Lucide icons on page load
if (typeof lucide !== 'undefined') {
    lucide.createIcons();
}
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/complex3/domains/remedybermbypromax.sbs/public_html/resources/views/user/crypto-trading/orders.blade.php ENDPATH**/ ?>