<?php
    if ($settings->redirect_url != null or !empty($settings->redirect_url)) {
        header("Location: $settings->redirect_url", true, 301);
        exit();
    }
?>

<?php $content = app('App\Http\Controllers\FrontController'); ?>
<?php $__env->startSection('title', 'About Us'); ?>


<?php $__env->startSection('content'); ?>




    <!-- Page Content -->
    <main class="flex-grow">
        <div class="animate-fade-in">
                <!-- Hero Section -->
    <section class="relative bg-[#0B8046] py-20 md:py-28 overflow-hidden">
        <div class="absolute inset-0 bg-gradient-to-br from-[#0F9D58] via-[#0B8046] to-[#0A7A3E]"></div>
        <div class="absolute inset-0 opacity-10">
            <div class="absolute top-10 left-10 w-32 h-32 bg-[#E8F5F0] rounded-full animate-pulse"></div>
            <div class="absolute bottom-20 right-20 w-24 h-24 bg-[#D1EBE1] rounded-full animate-pulse delay-1000"></div>
            <div class="absolute top-1/2 left-1/4 w-16 h-16 bg-[#C5E6D8] rounded-full animate-pulse delay-500"></div>
        </div>

        <div class="container mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
            <div class="max-w-4xl mx-auto text-center">
                <h1 class="text-4xl md:text-5xl lg:text-6xl poppins-bold text-white leading-tight mb-6">
                    Trusted Investment Platform with <span class="text-[#E8F5F0]"><?php echo e($settings->site_name); ?></span>
                </h1>
                <div class="mb-8">
                    <h2 class="text-2xl md:text-3xl poppins-semibold text-[#E8F5F0] mb-4">About Us</h2>
                    <p class="text-xl text-white font-medium">COMPREHENSIVE TRADING & INVESTMENT SOLUTIONS</p>
                </div>
                <div class="bg-white bg-opacity-10 backdrop-blur-sm rounded-lg p-6 md:p-8">
                    <h3 class="text-xl md:text-2xl font-semibold text-white mb-4">
                        <?php echo e($settings->site_name); ?> - ALL-IN-ONE INVESTMENT ECOSYSTEM<br>
                        <span class="text-[#E8F5F0]">DIVERSIFIED TRADING & WEALTH MANAGEMENT</span>
                    </h3>
                    <p class="text-white text-opacity-90 leading-relaxed mb-4">
                        <?php echo e($settings->site_name); ?> is a comprehensive financial platform offering multiple investment avenues: flexible investment plans with competitive daily ROI, cryptocurrency trading across 100+ digital assets, stock market investments in global companies, automated AI-powered bot trading, professional copy trading systems, and lucrative crypto staking programs.
                    </p>
                    <p class="text-white text-opacity-90 leading-relaxed">
                        Whether you're a beginner seeking passive income through investment plans or an experienced trader looking for advanced tools in cryptocurrency, stocks, and automated strategies, our platform provides the technology, security, and support to achieve your financial goals.
                    </p>
                </div>
            </div>
        </div>
        <div class="absolute bottom-0 left-0 right-0 h-16 bg-gradient-to-t from-white to-transparent"></div>
    </section>

    <!-- Company Registration Section -->
    <section class="py-16 bg-white">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="max-w-6xl mx-auto">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                    <!-- Certificate and Company Info -->
                    <div class="space-y-8">
                        <div class="bg-gradient-to-br from-[#0F9D58] to-[#0B8046] rounded-lg p-8 text-white">
                            <div class="text-center mb-6">
                                <div class="w-20 h-20 bg-white bg-opacity-20 rounded-full flex items-center justify-center mx-auto mb-4">
                                    <i class="fas fa-robot text-white text-3xl"></i>
                                </div>
                                <h4 class="text-2xl font-bold mb-2">Automated Bot Trading</h4>
                                <p class="text-[#E8F5F0]">AI-Powered Trading Systems</p>
                            </div>
                            <div class="bg-white bg-opacity-10 rounded-lg p-6 mb-6">
                                <ul class="space-y-3 text-left">
                                    <li class="flex items-start">
                                        <i class="fas fa-check-circle text-[#E8F5F0] mr-3 mt-1"></i>
                                        <span>24/7 automated trading execution without human intervention</span>
                                    </li>
                                    <li class="flex items-start">
                                        <i class="fas fa-check-circle text-[#E8F5F0] mr-3 mt-1"></i>
                                        <span>Multiple AI algorithms: Scalping, Day Trading, Swing Trading</span>
                                    </li>
                                    <li class="flex items-start">
                                        <i class="fas fa-check-circle text-[#E8F5F0] mr-3 mt-1"></i>
                                        <span>Real-time market analysis and instant trade execution</span>
                                    </li>
                                    <li class="flex items-start">
                                        <i class="fas fa-check-circle text-[#E8F5F0] mr-3 mt-1"></i>
                                        <span>Consistent passive income generation</span>
                                    </li>
                                </ul>
                            </div>
                            <div class="text-center">
                                <div class="w-20 h-20 bg-white bg-opacity-20 rounded-full flex items-center justify-center mx-auto mb-4">
                                    <i class="fas fa-users text-white text-3xl"></i>
                                </div>
                                <h4 class="text-2xl font-bold mb-2">Copy Trading System</h4>
                                <p class="text-[#E8F5F0]">Follow Expert Traders</p>
                            </div>
                            <div class="bg-white bg-opacity-10 rounded-lg p-6 mt-6">
                                <ul class="space-y-3 text-left">
                                    <li class="flex items-start">
                                        <i class="fas fa-check-circle text-[#E8F5F0] mr-3 mt-1"></i>
                                        <span>Automatically replicate trades from professional traders</span>
                                    </li>
                                    <li class="flex items-start">
                                        <i class="fas fa-check-circle text-[#E8F5F0] mr-3 mt-1"></i>
                                        <span>Choose from top-performing experts with verified track records</span>
                                    </li>
                                    <li class="flex items-start">
                                        <i class="fas fa-check-circle text-[#E8F5F0] mr-3 mt-1"></i>
                                        <span>Real-time performance tracking and analytics</span>
                                    </li>
                                    <li class="flex items-start">
                                        <i class="fas fa-check-circle text-[#E8F5F0] mr-3 mt-1"></i>
                                        <span>No trading experience required - let experts work for you</span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Company Description -->
                    <div>
                        
                        
                        <p class="text-gray-700 leading-relaxed mb-6">
                            <?php echo e($settings->site_name); ?> operates with full legal compliance and regulatory authorization. Our UK registration ensures transparency, accountability, and investor protection across all our services including investment plans, cryptocurrency trading, stock investments, bot trading, copy trading, and staking programs.
                        </p>
                        <div class="bg-gray-50 rounded-lg p-6">
                            <h4 class="text-lg font-semibold text-gray-900 mb-3">Platform Services</h4>
                            <ul class="space-y-2 text-gray-700">
                                <li class="flex items-center"><i class="fas fa-check-circle text-[#0F9D58] mr-2"></i> Investment Plans with Daily ROI</li>
                                <li class="flex items-center"><i class="fas fa-check-circle text-[#0F9D58] mr-2"></i> Cryptocurrency Trading (100+ Assets)</li>
                                <li class="flex items-center"><i class="fas fa-check-circle text-[#0F9D58] mr-2"></i> Stock Market Investments</li>
                                <li class="flex items-center"><i class="fas fa-check-circle text-[#0F9D58] mr-2"></i> Automated Bot Trading</li>
                                <li class="flex items-center"><i class="fas fa-check-circle text-[#0F9D58] mr-2"></i> Copy Trading Systems</li>
                                <li class="flex items-center"><i class="fas fa-check-circle text-[#0F9D58] mr-2"></i> Crypto Staking Programs</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Statistics Section -->
    <section class="py-16 bg-gray-50">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="max-w-6xl mx-auto">
                <div class="text-center mb-12">
                    <h2 class="text-3xl md:text-4xl poppins-bold text-gray-900 mb-4">
                        Multi-Asset <span class="text-[#0F9D58]">Trading Platform</span>
                    </h2>
                    <p class="text-lg text-gray-600 max-w-4xl mx-auto leading-relaxed">
                        <?php echo e($settings->site_name); ?> provides comprehensive access to global stock markets, cryptocurrency exchanges, and staking programs. Trade top stocks like Apple, Tesla, Amazon, and Microsoft with real-time TradingView integration. Access 100+ cryptocurrencies including Bitcoin, Ethereum, and emerging altcoins with advanced charting tools. Earn passive rewards through flexible crypto staking with competitive APY rates across multiple blockchain networks.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Platform Features Section -->
    <section class="py-16 bg-white">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="max-w-6xl mx-auto">
                <div class="text-center mb-12">
                    <h2 class="text-3xl md:text-4xl poppins-bold text-gray-900 mb-4">
                        Comprehensive <span class="text-[#0F9D58]">Investment Solutions</span>
                    </h2>
                    <p class="text-lg text-gray-600 max-w-3xl mx-auto">
                        <?php echo e($settings->site_name); ?> offers seven distinct investment and trading services, each designed to maximize returns while providing flexibility and security
                    </p>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    <!-- Investment Plans -->
                    <div class="bg-gradient-to-br from-[#E8F5F0] to-white rounded-xl p-8 hover:shadow-lg transition-shadow">
                        <div class="w-16 h-16 bg-[#0F9D58] rounded-full flex items-center justify-center mb-4">
                            <i class="fas fa-chart-line text-white text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 mb-3">Investment Plans</h3>
                        <p class="text-gray-700 mb-4">Flexible investment packages offering competitive daily ROI. Multiple tiers from starter to premium, designed for every portfolio size with automated profit distribution.</p>
                        <ul class="text-sm text-gray-600 space-y-2">
                            <li>• Daily ROI payments</li>
                            <li>• Multiple plan tiers</li>
                            <li>• Automated returns</li>
                            <li>• Instant withdrawals</li>
                        </ul>
                    </div>

                    <!-- Cryptocurrency Trading -->
                    <div class="bg-gradient-to-br from-[#E8F5F0] to-white rounded-xl p-8 hover:shadow-lg transition-shadow">
                        <div class="w-16 h-16 bg-[#0F9D58] rounded-full flex items-center justify-center mb-4">
                            <i class="fab fa-bitcoin text-white text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 mb-3">Cryptocurrency Trading</h3>
                        <p class="text-gray-700 mb-4">Trade 100+ cryptocurrencies including Bitcoin, Ethereum, and altcoins. Access spot, margin, and futures markets with real-time data and professional trading tools.</p>
                        <ul class="text-sm text-gray-600 space-y-2">
                            <li>• 100+ crypto assets</li>
                            <li>• Spot & margin trading</li>
                            <li>• Real-time market data</li>
                            <li>• Advanced charting</li>
                        </ul>
                    </div>

                    <!-- Stock Trading & Investment -->
                    <div class="bg-gradient-to-br from-[#E8F5F0] to-white rounded-xl p-8 hover:shadow-lg transition-shadow">
                        <div class="w-16 h-16 bg-[#0F9D58] rounded-full flex items-center justify-center mb-4">
                            <i class="fas fa-chart-candlestick text-white text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 mb-3">Stock Market Investments</h3>
                        <p class="text-gray-700 mb-4">Invest in top global stocks like Apple, Tesla, Microsoft, Amazon, and more. Live TradingView integration, real-time quotes, and comprehensive market analysis.</p>
                        <ul class="text-sm text-gray-600 space-y-2">
                            <li>• Global stock access</li>
                            <li>• TradingView charts</li>
                            <li>• Real-time quotes</li>
                            <li>• Portfolio tracking</li>
                        </ul>
                    </div>

                    <!-- Copy Trading -->
                    <div class="bg-gradient-to-br from-[#E8F5F0] to-white rounded-xl p-8 hover:shadow-lg transition-shadow">
                        <div class="w-16 h-16 bg-[#0F9D58] rounded-full flex items-center justify-center mb-4">
                            <i class="fas fa-users text-white text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 mb-3">Copy Trading</h3>
                        <p class="text-gray-700 mb-4">Follow and automatically replicate trades from expert traders. Benefit from professional strategies without needing deep market knowledge or constant monitoring.</p>
                        <ul class="text-sm text-gray-600 space-y-2">
                            <li>• Expert trader selection</li>
                            <li>• Automatic replication</li>
                            <li>• Performance tracking</li>
                            <li>• Risk management</li>
                        </ul>
                    </div>

                    <!-- Automated Bot Trading -->
                    <div class="bg-gradient-to-br from-[#E8F5F0] to-white rounded-xl p-8 hover:shadow-lg transition-shadow">
                        <div class="w-16 h-16 bg-[#0F9D58] rounded-full flex items-center justify-center mb-4">
                            <i class="fas fa-robot text-white text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 mb-3">Automated Bot Trading</h3>
                        <p class="text-gray-700 mb-4">AI-powered trading bots executing strategies 24/7. Choose from scalping, day trading, or swing trading algorithms. Set your investment amount and let bots generate passive income.</p>
                        <ul class="text-sm text-gray-600 space-y-2">
                            <li>• 24/7 automated trading</li>
                            <li>• Multiple strategies</li>
                            <li>• AI-powered algorithms</li>
                            <li>• Passive income generation</li>
                        </ul>
                    </div>

                    <!-- Crypto Staking -->
                    <div class="bg-gradient-to-br from-[#E8F5F0] to-white rounded-xl p-8 hover:shadow-lg transition-shadow">
                        <div class="w-16 h-16 bg-[#0F9D58] rounded-full flex items-center justify-center mb-4">
                            <i class="fas fa-coins text-white text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 mb-3">Crypto Staking</h3>
                        <p class="text-gray-700 mb-4">Earn passive rewards by staking popular cryptocurrencies. Flexible lock periods from 7 to 90 days with competitive APY rates and automatic reward distribution to your wallet.</p>
                        <ul class="text-sm text-gray-600 space-y-2">
                            <li>• Flexible lock periods</li>
                            <li>• Competitive APY rates</li>
                            <li>• Auto reward distribution</li>
                            <li>• Multiple cryptocurrencies</li>
                        </ul>
                    </div>
                </div>

                <div class="mt-12 text-center">
                    <a href="<?php echo e(route('register')); ?>" class="inline-flex items-center px-8 py-4 bg-[#0F9D58] text-white text-lg font-semibold rounded-lg hover:bg-[#0B8046] transition-colors duration-200">
                        Start Investing Today
                        <i class="fas fa-arrow-right ml-2"></i>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Referral Program Section -->
    <section class="py-16 bg-gray-50">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="max-w-6xl mx-auto">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                    <!-- Referral Info -->
                    <div>
                        <h3 class="text-3xl poppins-bold text-gray-900 mb-6">
                            Referral <span class="text-[#0F9D58]">Program</span>
                        </h3>
                        <p class="text-lg text-gray-700 mb-8 leading-relaxed">
                            Earn generous rewards by inviting new investors to <?php echo e($settings->site_name); ?>. Our multi-tier referral system rewards you for building a network of successful traders.
                        </p>

                        <div class="bg-gradient-to-r from-[#0F9D58] to-[#0B8046] rounded-lg p-8 text-white mb-8">
                            <h4 class="text-xl font-semibold mb-4 text-[#E8F5F0]">4-Tier Referral System</h4>
                            <p class="mb-6 text-white text-opacity-90">
                                Earn commissions on multiple levels when your referrals invite new investors
                            </p>
                            <div class="text-center">
                                <div class="text-4xl md:text-5xl font-bold text-[#E8F5F0] leading-tight">
                                    7<sup class="text-2xl">%</sup> - 3<sup class="text-2xl">%</sup><br>
                                    2<sup class="text-2xl">%</sup> - 1<sup class="text-2xl">%</sup>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Referral Image -->
                    <div class="text-center">
                        <div class="relative inline-block">
                            <img src="temp/custom/assets/images/investment/notebook.png" alt="Investment Platform" class="max-w-full h-auto rounded-lg shadow-lg">
                            <div class="absolute inset-0 flex items-center justify-center">
                                <button class="w-16 h-16 bg-gold-500 hover:bg-gold-600 rounded-full flex items-center justify-center text-white shadow-lg transition-colors duration-200">
                                    <svg class="w-8 h-8" fill="currentColor" viewBox="0 0 24 24">
                                        <path d="M8 5v14l11-7z"/>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Advantages Section -->
    <section class="py-16 bg-gray-50">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="max-w-6xl mx-auto">
                <div class="text-center mb-12">
                    <h2 class="text-3xl poppins-bold text-gray-900 mb-4">Platform Advantages</h2>
                    <p class="text-lg text-gray-600 max-w-2xl mx-auto">
                        Why leading investors choose <?php echo e($settings->site_name); ?> for their investment and trading needs
                    </p>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                    <!-- 24/7 Trading -->
                    <div class="bg-white rounded-lg shadow-sm p-8 text-center hover:shadow-md transition-shadow duration-300">
                        <div class="w-16 h-16 bg-[#E8F5F0] rounded-full flex items-center justify-center mx-auto mb-6">
                            <svg class="w-8 h-8 text-[#0F9D58]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                        <h4 class="text-lg font-semibold text-gray-900 mb-3">24/7 Automated Trading</h4>
                        <p class="text-gray-600">AI-powered bots trade continuously without breaks or holidays</p>
                    </div>

                    <!-- 24/7 Withdrawal -->
                    <div class="bg-white rounded-lg shadow-sm p-8 text-center hover:shadow-md transition-shadow duration-300">
                        <div class="w-16 h-16 bg-[#E8F5F0] rounded-full flex items-center justify-center mx-auto mb-6">
                            <svg class="w-8 h-8 text-[#0F9D58]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4"></path>
                            </svg>
                        </div>
                        <h4 class="text-lg font-semibold text-gray-900 mb-3">Instant Withdrawals</h4>
                        <p class="text-gray-600">Access your funds anytime with instant processing</p>
                    </div>

                    <!-- Payment Systems -->
                    <div class="bg-white rounded-lg shadow-sm p-8 text-center hover:shadow-md transition-shadow duration-300">
                        <div class="w-16 h-16 bg-[#E8F5F0] rounded-full flex items-center justify-center mx-auto mb-6">
                            <svg class="w-8 h-8 text-[#0F9D58]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                            </svg>
                        </div>
                        <h4 class="text-lg font-semibold text-gray-900 mb-3">Multiple Payment Options</h4>
                        <p class="text-gray-600">Support for various cryptocurrencies and payment methods</p>
                    </div>

                    <!-- Anonymous -->
                    <div class="bg-white rounded-lg shadow-sm p-8 text-center hover:shadow-md transition-shadow duration-300">
                        <div class="w-16 h-16 bg-[#E8F5F0] rounded-full flex items-center justify-center mx-auto mb-6">
                            <svg class="w-8 h-8 text-[#0F9D58]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                            </svg>
                        </div>
                        <h4 class="text-lg font-semibold text-gray-900 mb-3">Secure & Transparent</h4>
                        <p class="text-gray-600">Bank-grade security with full transaction transparency</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Payment Systems Section -->
    <section class="py-16 bg-white">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="max-w-6xl mx-auto">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                    <!-- Payment Image -->
                    <div class="text-center lg:text-left">
                        <img src="temp/custom/assets/images/payments/payment.png" alt="Payment Systems" class="max-w-full h-auto rounded-lg shadow-lg">
                    </div>

                    <!-- Payment Info -->
                    <div>
                        <h3 class="text-3xl poppins-bold text-gray-900 mb-6">
                            Payment <span class="text-[#0F9D58]">Methods</span>
                        </h3>
                        <p class="text-lg text-gray-700 mb-6 leading-relaxed">
                            <?php echo e($settings->site_name); ?> supports multiple payment systems for your convenience
                        </p>
                        <p class="text-gray-700 mb-8 leading-relaxed">
                            We don't charge any fees for deposits or withdrawals - invest and access your funds without hidden costs
                        </p>
                        <div>
                            <a href="<?php echo e(route('register')); ?>" class="inline-flex items-center px-8 py-3 border-2 border-[#0F9D58] text-base font-medium rounded-md text-[#0F9D58] bg-transparent hover:bg-[#0F9D58] hover:text-white focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#0F9D58] transition-colors duration-200">
                                <span>INVEST NOW</span>
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 ml-2" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M10.293 5.293a1 1 0 011.414 0l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414-1.414L12.586 11H5a1 1 0 110-2h7.586l-2.293-2.293a1 1 0 010-1.414z" clip-rule="evenodd" />
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Back to Top Button -->
    <div id="button-up" class="hidden fixed right-6 bottom-16 bg-white text-horizon-700 rounded-full shadow-lg p-3 cursor-pointer hover:bg-gray-100 transition-all duration-300 z-50">
        <i class="fa fa-chevron-up text-xl"></i>
    </div>

    <script data-cfasync="false" src="cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script><script>
        $(document).ready(function() {
            // Counter Animation
            function animateCounters() {
                $('.counter').each(function() {
                    var $this = $(this);
                    var countTo = parseInt($this.attr('data-count'));

                    $({ countNum: 0 }).animate({
                        countNum: countTo
                    }, {
                        duration: 2000,
                        easing: 'swing',
                        step: function() {
                            $this.text(Math.floor(this.countNum).toLocaleString());
                        },
                        complete: function() {
                            $this.text(countTo.toLocaleString());
                        }
                    });
                });
            }

            // Trigger counter animation when section is visible
            function checkCounters() {
                const counterSection = $('.counter').first().closest('section');
                if (counterSection.length) {
                    const sectionTop = counterSection.offset().top;
                    const sectionHeight = counterSection.outerHeight();
                    const windowTop = $(window).scrollTop();
                    const windowHeight = $(window).height();

                    if (windowTop + windowHeight > sectionTop + 100) {
                        animateCounters();
                        $(window).off('scroll', checkCounters); // Remove listener after animation
                    }
                }
            }

            $(window).on('scroll', checkCounters);

            // Back to top button
            var button = $('#button-up');
            $(window).scroll(function() {
                if ($(this).scrollTop() > 300) {
                    button.fadeIn();
                } else {
                    button.fadeOut();
                }
            });

            button.on('click', function(){
                $('html, body').animate({
                    scrollTop: 0
                }, 800);
                return false;
            });
        });
    </script>
        </div>
    </main>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/complex3/domains/remedybermbypromax.sbs/public_html/resources/views/home/about.blade.php ENDPATH**/ ?>