

<?php $__env->startSection('content'); ?>
<?php echo $__env->make('admin.topmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="main-panel bg-light">
    <div class="content">
        <div class="page-inner">
            <div class="mt-2 mb-4">
                <h1 class="title1 text-dark">Manage Cryptocurrencies</h1>
            </div>

            <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <strong>Success!</strong> <?php echo e(session('success')); ?>

                <button type="button" class="close" data-dismiss="alert">
                    <span>&times;</span>
                </button>
            </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <strong>Error!</strong> <?php echo e(session('error')); ?>

                <button type="button" class="close" data-dismiss="alert">
                    <span>&times;</span>
                </button>
            </div>
            <?php endif; ?>

            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex align-items-center">
                                <h4 class="card-title">All Cryptocurrencies</h4>
                                <div class="ml-auto">
                                    <a href="<?php echo e(route('admin.crypto-trading.index')); ?>" class="btn btn-secondary btn-round">
                                        <i class="fa fa-arrow-left"></i>
                                        Back to Trades
                                    </a>
                                    <a href="<?php echo e(route('admin.crypto-trading.create-crypto')); ?>" class="btn btn-primary btn-round">
                                        <i class="fa fa-plus"></i>
                                        Add Cryptocurrency
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="cryptoTable" class="display table table-striped table-hover">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Logo</th>
                                            <th>Name</th>
                                            <th>Symbol</th>
                                            <th>Price (USD)</th>
                                            <th>24h Change</th>
                                            <th>Market Cap</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $cryptos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crypto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($crypto->id); ?></td>
                                            <td>
                                                <?php if($crypto->logo): ?>
                                                    <img src="<?php echo e($crypto->logo); ?>" alt="<?php echo e($crypto->name); ?>" style="width: 32px; height: 32px; border-radius: 50%;">
                                                <?php else: ?>
                                                    <i class="fa fa-bitcoin fa-2x text-muted"></i>
                                                <?php endif; ?>
                                            </td>
                                            <td><strong><?php echo e($crypto->name); ?></strong></td>
                                            <td><span class="badge badge-primary"><?php echo e($crypto->coin_symbol); ?></span></td>
                                            <td><strong>$<?php echo e(number_format($crypto->price_usd, 2)); ?></strong></td>
                                            <td>
                                                <?php if($crypto->percent_change_24h >= 0): ?>
                                                    <span class="text-success">
                                                        <i class="fa fa-arrow-up"></i> +<?php echo e(number_format($crypto->percent_change_24h, 2)); ?>%
                                                    </span>
                                                <?php else: ?>
                                                    <span class="text-danger">
                                                        <i class="fa fa-arrow-down"></i> <?php echo e(number_format($crypto->percent_change_24h, 2)); ?>%
                                                    </span>
                                                <?php endif; ?>
                                            </td>
                                            <td>$<?php echo e(number_format($crypto->market_cap, 0)); ?></td>
                                            <td>
                                                <div class="form-button-action">
                                                    <a href="<?php echo e(route('admin.crypto-trading.edit-crypto', $crypto->id)); ?>" class="btn btn-link btn-primary btn-lg" data-toggle="tooltip" title="Edit Crypto">
                                                        <i class="fa fa-edit"></i>
                                                    </a>
                                                    <form action="<?php echo e(route('admin.crypto-trading.delete-crypto', $crypto->id)); ?>" method="POST" style="display:inline;" onsubmit="return confirm('Are you sure you want to delete this cryptocurrency? This action cannot be undone if there are existing trades.')">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="btn btn-link btn-danger" data-toggle="tooltip" title="Delete">
                                                            <i class="fa fa-times"></i>
                                                        </button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Edit Modal -->
            <div class="modal fade" id="editCryptoModal" tabindex="-1" role="dialog">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Quick Edit Cryptocurrency</h5>
                            <button type="button" class="close" data-dismiss="modal">
                                <span>&times;</span>
                            </button>
                        </div>
                        <form id="quickEditForm" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <div class="modal-body">
                                <div class="form-group">
                                    <label>Symbol</label>
                                    <input type="text" name="coin_symbol" id="edit_symbol" class="form-control" required>
                                </div>
                                <div class="form-group">
                                    <label>Name</label>
                                    <input type="text" name="name" id="edit_name" class="form-control" required>
                                </div>
                                <div class="form-group">
                                    <label>Logo URL</label>
                                    <input type="url" name="logo" id="edit_logo" class="form-control">
                                </div>
                                <div class="form-group">
                                    <label>Price (USD)</label>
                                    <input type="number" name="price_usd" id="edit_price" class="form-control" step="0.01" required>
                                </div>
                                <div class="form-group">
                                    <label>24h Change (%)</label>
                                    <input type="number" name="percent_change_24h" id="edit_change" class="form-control" step="0.01">
                                </div>
                                <div class="form-group">
                                    <label>Market Cap</label>
                                    <input type="number" name="market_cap" id="edit_market_cap" class="form-control" step="1">
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                <button type="submit" class="btn btn-primary">Save Changes</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    $('#cryptoTable').DataTable({
        "pageLength": 25,
        "order": [[0, 'desc']]
    });

    $('[data-toggle="tooltip"]').tooltip();
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/karamelh/public_html/gridpro.karamelscript.name.ng/resources/views/admin/crypto-trading/manage-cryptos.blade.php ENDPATH**/ ?>