

<?php $__env->startSection('content'); ?>
<?php echo $__env->make('admin.topmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="main-panel">
    <div class="content bg-light">
        <div class="page-inner">
            <div class="mt-2 mb-4">
                <h1 class="title1 text-dark">Stock Trading Settings</h1>
            </div>

            <div class="mb-5 row">
                <div class="col-lg-8 offset-lg-2">
                    <div class="card shadow">
                        <div class="card-body">
                            <?php if(session('success')): ?>
                                <div class="alert alert-success alert-dismissible fade show" role="alert">
                                    <?php echo e(session('success')); ?>

                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            <?php endif; ?>

                            <?php if(session('error')): ?>
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <?php echo e(session('error')); ?>

                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            <?php endif; ?>

                            <?php if($errors->any()): ?>
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <strong>Error!</strong> Please fix the following issues:
                                    <ul class="mb-0">
                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($error); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            <?php endif; ?>

                            <form action="<?php echo e(route('admin.stock-trading.update-settings')); ?>" method="POST">
                                <?php echo csrf_field(); ?>

                                <!-- Enable Stock Trading -->
                            <div class="form-group">
                                <label>Enable Stock Trading Module</label>
                                <div class="selectgroup w-100">
                                    <label class="selectgroup-item">
                                        <input type="radio" name="enable_stock_trading" value="on" class="selectgroup-input" 
                                            <?php echo e($settings->enable_stock_trading == 'on' ? 'checked' : ''); ?>>
                                        <span class="selectgroup-button">Enabled</span>
                                    </label>
                                    <label class="selectgroup-item">
                                        <input type="radio" name="enable_stock_trading" value="off" class="selectgroup-input"
                                            <?php echo e($settings->enable_stock_trading == 'off' ? 'checked' : ''); ?>>
                                        <span class="selectgroup-button">Disabled</span>
                                    </label>
                                </div>
                                <small class="form-text text-muted">Enable or disable the stock trading module for all users</small>
                            </div>

                            <!-- Twelve Data API Key -->
                            <div class="form-group">
                                <label for="twelvedata_api_key">Twelve Data API Key *</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['twelvedata_api_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="twelvedata_api_key" name="twelvedata_api_key" 
                                    value="<?php echo e(old('twelvedata_api_key', $settings->twelvedata_api_key)); ?>" required>
                                <small class="form-text text-muted">
                                    Get your free API key from <a href="https://twelvedata.com" target="_blank">twelvedata.com</a>
                                </small>
                                <?php $__errorArgs = ['twelvedata_api_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Test API Connection -->
                            <div class="form-group">
                                <button type="button" id="testApiBtn" class="btn btn-info">
                                    <i class="fa fa-plug"></i> Test API Connection
                                </button>
                                <div id="apiTestResult" class="mt-2"></div>
                            </div>

                            <!-- Market Hours Detection -->
                            <div class="form-group">
                                <label>Stock Market Hours Detection</label>
                                <div class="selectgroup w-100">
                                    <label class="selectgroup-item">
                                        <input type="radio" name="stock_market_hours_enabled" value="on" class="selectgroup-input"
                                            <?php echo e($settings->stock_market_hours_enabled == 'on' ? 'checked' : ''); ?>>
                                        <span class="selectgroup-button">Enabled</span>
                                    </label>
                                    <label class="selectgroup-item">
                                        <input type="radio" name="stock_market_hours_enabled" value="off" class="selectgroup-input"
                                            <?php echo e($settings->stock_market_hours_enabled == 'off' ? 'checked' : ''); ?>>
                                        <span class="selectgroup-button">Disabled</span>
                                    </label>
                                </div>
                                <small class="form-text text-muted">When enabled, price updates skip NYSE holidays and weekends</small>
                            </div>

                            <!-- Max Watchlist Items -->
                            <div class="form-group">
                                <label for="max_stock_watchlist_items">Maximum Watchlist Items Per User *</label>
                                <input type="number" class="form-control <?php $__errorArgs = ['max_stock_watchlist_items'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="max_stock_watchlist_items" name="max_stock_watchlist_items" 
                                    min="1" max="100" 
                                    value="<?php echo e(old('max_stock_watchlist_items', $settings->max_stock_watchlist_items)); ?>" required>
                                <small class="form-text text-muted">Limit the number of stocks each user can add to their watchlist</small>
                                <?php $__errorArgs = ['max_stock_watchlist_items'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Trade Fee Percent -->
                            <div class="form-group">
                                <label for="stock_trade_fee_percent">Trade Fee Percentage *</label>
                                <div class="input-group">
                                    <input type="number" class="form-control <?php $__errorArgs = ['stock_trade_fee_percent'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="stock_trade_fee_percent" name="stock_trade_fee_percent" 
                                        min="0" max="10" step="0.01" 
                                        value="<?php echo e(old('stock_trade_fee_percent', $settings->stock_trade_fee_percent)); ?>" required>
                                    <div class="input-group-append">
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                                <small class="form-text text-muted">Fee charged on each trade (0-10%). For buy: user pays total+fee, for sell: user receives total-fee</small>
                                <?php $__errorArgs = ['stock_trade_fee_percent'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="form-group text-right mt-4">
                                <a href="<?php echo e(route('admin.stock-trading.index')); ?>" class="btn btn-secondary">
                                    <i class="fa fa-arrow-left"></i> Back to Trades
                                </a>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-save"></i> Save Settings
                                </button>
                            </div>
                            </form>

                            <hr class="my-4">
                            <h5 class="mb-3">Force Update & Bulk Import</h5>

                            <!-- Force Update Section -->
                            <div class="form-group">
                                <label>Force Update Stock Prices</label>
                                <?php if($lastForceUpdate): ?>
                                <div class="alert alert-info">
                                    <small>
                                        <strong>Last forced update:</strong><br>
                                        <?php echo e($lastForceUpdate->diffForHumans()); ?>

                                    </small>
                                </div>
                                <?php endif; ?>

                                <?php if($canForceUpdate): ?>
                                <p class="text-muted">Manually trigger stock price updates, bypassing market hours check.</p>
                                <button type="button" id="forceUpdateBtn" class="btn btn-warning">
                                    <i class="fa fa-refresh"></i> Force Update Now
                                </button>
                                <?php else: ?>
                                <div class="alert alert-warning">
                                    <small>
                                        <i class="fa fa-clock-o"></i> Please wait <?php echo e($cooldownMinutes); ?> minutes between force updates.<br>
                                        Next available: <?php echo e($nextForceUpdate->diffForHumans()); ?>

                                    </small>
                                </div>
                                <button type="button" class="btn btn-warning" disabled>
                                    <i class="fa fa-refresh"></i> Force Update (Cooldown)
                                </button>
                                <?php endif; ?>
                                
                                <div id="forceUpdateResult" class="mt-3"></div>
                            </div>

                            <hr class="my-4">

                            <!-- Bulk Import Section -->
                            <div class="form-group">
                                <label>Bulk Import Stocks</label>
                                <p class="text-muted">Add popular stock symbols to the system.</p>
                                
                                <div class="row">
                                    <div class="col-md-4">
                                        <form action="<?php echo e(route('admin.stock-trading.add-preset')); ?>" method="POST" class="mb-2">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="preset" value="sp500">
                                            <button type="submit" class="btn btn-info btn-block">
                                                <i class="fa fa-plus"></i> Add S&P 500 (30)
                                            </button>
                                        </form>
                                    </div>
                                    <div class="col-md-4">
                                        <form action="<?php echo e(route('admin.stock-trading.add-preset')); ?>" method="POST" class="mb-2">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="preset" value="nasdaq100">
                                            <button type="submit" class="btn btn-info btn-block">
                                                <i class="fa fa-plus"></i> Add NASDAQ 100 (30)
                                            </button>
                                        </form>
                                    </div>
                                    <div class="col-md-4">
                                        <form action="<?php echo e(route('admin.stock-trading.add-preset')); ?>" method="POST" class="mb-2">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="preset" value="dow30">
                                            <button type="submit" class="btn btn-info btn-block">
                                                <i class="fa fa-plus"></i> Add DOW 30 (30)
                                            </button>
                                        </form>
                                    </div>
                                </div>

                                <form action="<?php echo e(route('admin.stock-trading.bulk-import')); ?>" method="POST" enctype="multipart/form-data" class="mt-3">
                                    <?php echo csrf_field(); ?>
                                    <div class="form-group">
                                        <label>Or Upload CSV File</label>
                                        <input type="file" class="form-control-file" name="csv_file" accept=".csv" required>
                                        <small class="form-text text-muted">CSV format: symbol, name, exchange</small>
                                    </div>
                                    <button type="submit" class="btn btn-success">
                                        <i class="fa fa-upload"></i> Upload CSV
                                    </button>
                                </form>
                            </div>

                            <div class="alert alert-info mt-4" role="alert">
                                <i class="fa fa-info-circle"></i> <strong>Information:</strong>
                                <ul class="mb-0 mt-2">
                                    <li><strong>Scheduled Updates:</strong> Every 15 minutes</li>
                                    <li><strong>NYSE Trading Hours:</strong> 9:30 AM - 4:00 PM ET</li>
                                    <li><strong>Cooldown:</strong> 5 minutes between manual updates</li>
                                    <li><strong>API Limits:</strong> 8 requests per minute</li>
                                </ul>
                            </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

</div>

<script>
$(document).ready(function() {
    // Test API Connection
    $('#testApiBtn').click(function() {
        const btn = $(this);
        const resultDiv = $('#apiTestResult');
        const apiKey = $('#twelvedata_api_key').val();

        if (!apiKey) {
            resultDiv.html('<div class="alert alert-warning">Please enter an API key first</div>');
            return;
        }

        btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Testing...');
        resultDiv.html('');

        $.ajax({
            url: '<?php echo e(route('admin.stock-trading.test-api')); ?>',
            method: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                api_key: apiKey
            },
            success: function(response) {
                if (response.success) {
                    resultDiv.html('<div class="alert alert-success"><i class="fa fa-check"></i> API connection successful!</div>');
                } else {
                    resultDiv.html('<div class="alert alert-danger"><i class="fa fa-times"></i> ' + response.message + '</div>');
                }
            },
            error: function(xhr) {
                const error = xhr.responseJSON?.message || 'API test failed';
                resultDiv.html('<div class="alert alert-danger"><i class="fa fa-times"></i> ' + error + '</div>');
            },
            complete: function() {
                btn.prop('disabled', false).html('<i class="fa fa-plug"></i> Test API Connection');
            }
        });
    });

    // Force Update
    $('#forceUpdateBtn').click(function() {
        if (!confirm('Force update all stock prices? This will trigger price updates regardless of market hours.')) {
            return;
        }

        const btn = $(this);
        const resultDiv = $('#forceUpdateResult');

        btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Updating...');
        resultDiv.html('');

        $.ajax({
            url: '<?php echo e(route('admin.stock-trading.force-update')); ?>',
            method: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>'
            },
            success: function(response) {
                if (response.success) {
                    resultDiv.html('<div class="alert alert-success"><i class="fa fa-check"></i> ' + response.message + '</div>');
                    setTimeout(function() {
                        location.reload();
                    }, 2000);
                } else {
                    resultDiv.html('<div class="alert alert-danger"><i class="fa fa-times"></i> ' + response.message + '</div>');
                    btn.prop('disabled', false).html('<i class="fa fa-refresh"></i> Force Update Now');
                }
            },
            error: function(xhr) {
                const error = xhr.responseJSON?.message || 'Force update failed';
                resultDiv.html('<div class="alert alert-danger"><i class="fa fa-times"></i> ' + error + '</div>');
                btn.prop('disabled', false).html('<i class="fa fa-refresh"></i> Force Update Now');
            }
        });
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/karamelh/public_html/gridpro.karamelscript.name.ng/resources/views/admin/stock-trading/settings.blade.php ENDPATH**/ ?>